/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

final class HoverRowTable
extends JBTable {
    private int myHoveredRow = -1;
    private final Color myHoverColor;

    HoverRowTable(@NotNull TableModel model, @NotNull Color hoverColor) {
        super(model);
        this.myHoverColor = hoverColor;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                HoverRowTable.this.hoveredRowChanged(HoverRowTable.this.rowAtPoint(e.getPoint()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HoverRowTable.this.hoveredRowChanged(-1);
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
        this.getEmptyText().clear();
    }

    private void hoveredRowChanged(int row) {
        if (row == this.myHoveredRow) {
            return;
        }
        this.myHoveredRow = row;
        this.repaint();
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
        Component comp;
        Component toChangeComp = comp = super.prepareRenderer(renderer, row, column);
        if (comp instanceof ExpandedItemRendererComponentWrapper) {
            toChangeComp = ((ExpandedItemRendererComponentWrapper)comp).getComponent(0);
        }
        if (this.getRowSelectionAllowed() && this.isRowSelected(row)) {
            toChangeComp.setForeground(this.getSelectionForeground());
            toChangeComp.setBackground(this.getSelectionBackground());
        } else if (row == this.myHoveredRow) {
            toChangeComp.setBackground(this.myHoverColor);
            toChangeComp.setForeground(this.getForeground());
        } else {
            toChangeComp.setBackground(this.getBackground());
            toChangeComp.setForeground(this.getForeground());
        }
        return comp;
    }

    public void paint(@NotNull Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, UIUtil.getLcdContrastValue());
        }
        super.paint(g);
        g.setColor(this.getGridColor());
        TableColumnModel columnModel = this.getColumnModel();
        int x = 0;
        if (this.getComponentOrientation().isLeftToRight()) {
            for (int column = 0; column < columnModel.getColumnCount() - 1; ++column) {
                g.drawLine((x += columnModel.getColumn(column).getWidth()) - 1, 0, x - 1, this.getHeight());
            }
        } else {
            for (int column = columnModel.getColumnCount() - 1; column > 0; --column) {
                g.drawLine((x += columnModel.getColumn(column).getWidth()) - 1, 0, x - 1, this.getHeight());
            }
        }
    }
}

