/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.StackFrameParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpData {
    private static final Map<String, String> CONTENT_EXTENSIONS_MAP = new ImmutableMap.Builder().put((Object)"/bmp", (Object)".bmp").put((Object)"/gif", (Object)".gif").put((Object)"/html", (Object)".html").put((Object)"/jpeg", (Object)".jpg").put((Object)"/json", (Object)".json").put((Object)"/png", (Object)".png").put((Object)"/xml", (Object)".xml").build();
    private static final String STATUS_CODE_NAME = "response-status-code";
    public static final String FIELD_CONTENT_TYPE = "content-type";
    public static final String FIELD_CONTENT_LENGTH = "content-length";
    public static final int NO_STATUS_CODE = -1;
    private final long myId;
    private final long myStartTimeUs;
    private final long myEndTimeUs;
    private final long myDownloadingTimeUs;
    @NotNull
    private final String myUrl;
    @NotNull
    private final String myMethod;
    @NotNull
    private final StackTrace myTrace;
    @NotNull
    private final List<JavaThread> myThreads;
    @Nullable
    private final String myResponsePayloadId;
    private int myStatusCode = -1;
    private final Map<String, String> myResponseFields = new HashMap<String, String>();
    private final Map<String, String> myRequestFields = new HashMap<String, String>();
    private File myResponsePayloadFile;

    private HttpData(@NotNull Builder builder) {
        this.myId = builder.myId;
        this.myStartTimeUs = builder.myStartTimeUs;
        this.myEndTimeUs = builder.myEndTimeUs;
        this.myDownloadingTimeUs = builder.myDownloadingTimeUs;
        this.myUrl = builder.myUrl;
        this.myMethod = builder.myMethod;
        this.myTrace = new StackTrace(builder.myTrace);
        this.myThreads = builder.myThreads;
        this.myResponsePayloadId = builder.myResponsePayloadId;
        if (builder.myResponseFields != null) {
            this.parseResponseFields(builder.myResponseFields);
        }
        if (builder.myRequestFields != null) {
            this.parseRequestFields(builder.myRequestFields);
        }
    }

    public long getId() {
        return this.myId;
    }

    public long getStartTimeUs() {
        return this.myStartTimeUs;
    }

    public long getEndTimeUs() {
        return this.myEndTimeUs;
    }

    public long getDownloadingTimeUs() {
        return this.myDownloadingTimeUs;
    }

    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @NotNull
    public String getMethod() {
        return this.myMethod;
    }

    @NotNull
    public StackTrace getStackTrace() {
        return this.myTrace;
    }

    @NotNull
    public List<JavaThread> getJavaThreads() {
        return this.myThreads;
    }

    @Nullable
    public String getResponsePayloadId() {
        return this.myResponsePayloadId;
    }

    public int getStatusCode() {
        return this.myStatusCode;
    }

    @Nullable
    public File getResponsePayloadFile() {
        return this.myResponsePayloadFile;
    }

    public void setResponsePayloadFile(@NotNull File payloadFile) {
        this.myResponsePayloadFile = payloadFile;
    }

    @Nullable
    public String getResponseField(@NotNull String field) {
        return this.myResponseFields.get(field.toLowerCase());
    }

    @Nullable
    public ContentType getContentType() {
        String type = this.getResponseField(FIELD_CONTENT_TYPE);
        return type == null ? null : new ContentType(type);
    }

    @NotNull
    public ImmutableMap<String, String> getResponseHeaders() {
        return ImmutableMap.copyOf(this.myResponseFields);
    }

    @NotNull
    public ImmutableMap<String, String> getRequestHeaders() {
        return ImmutableMap.copyOf(this.myRequestFields);
    }

    private void parseResponseFields(@NotNull String fields) {
        String[] tokens;
        if ((fields = fields.trim()).isEmpty()) {
            return;
        }
        String[] firstLineSplit = fields.split("\\n", 2);
        String status = firstLineSplit[0].trim();
        if (!status.isEmpty() && (status = (tokens = status.split("=", 2))[tokens.length - 1].trim()).startsWith("HTTP/1.")) {
            this.myStatusCode = Integer.parseInt(status.split(" ")[1]);
            fields = firstLineSplit.length > 1 ? firstLineSplit[1] : "";
        }
        HttpData.parseHeaderFields(fields, this.myResponseFields);
        if (this.myResponseFields.containsKey(STATUS_CODE_NAME)) {
            String statusCode = this.myResponseFields.remove(STATUS_CODE_NAME);
            this.myStatusCode = Integer.parseInt(statusCode);
        }
        assert (this.myStatusCode != -1) : String.format("Unexpected http response (%s)", fields);
    }

    private void parseRequestFields(@NotNull String fields) {
        HttpData.parseHeaderFields(fields, this.myRequestFields);
    }

    private static void parseHeaderFields(@NotNull String fields, @NotNull Map<String, String> map) {
        map.clear();
        Arrays.stream(fields.split("\\n")).filter(line -> !line.trim().isEmpty()).forEach(line -> {
            String[] keyAndValue = line.split("=", 2);
            assert (keyAndValue.length == 2) : String.format("Unexpected http header field (%s)", line);
            map.put(keyAndValue[0].trim().toLowerCase(), StringUtil.trimEnd((String)keyAndValue[1].trim(), (char)';'));
        });
    }

    @NotNull
    public static String getUrlName(@NotNull String url) {
        URI uri = URI.create(url);
        if (uri.getPath().isEmpty()) {
            return uri.getHost();
        }
        String name = StringUtil.trimTrailing((String)uri.getPath(), (char)'/');
        String string = name = name.lastIndexOf(47) != -1 ? name.substring(name.lastIndexOf(47) + 1) : name;
        if (uri.getQuery() != null) {
            name = name + "?" + uri.getQuery();
        }
        try {
            String lastName;
            do {
                lastName = name;
            } while (!(name = URLDecoder.decode(name, "UTF-8")).equals(lastName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpData data = (HttpData)o;
        return this.myId == data.myId;
    }

    public int hashCode() {
        return Objects.hash(this.myId);
    }

    public static final class Builder {
        private final long myId;
        private final long myStartTimeUs;
        private final long myEndTimeUs;
        private final long myDownloadingTimeUs;
        private String myUrl;
        private String myMethod;
        private String myResponseFields;
        private String myRequestFields;
        private String myResponsePayloadId;
        private String myTrace = "";
        private List<JavaThread> myThreads = new ArrayList<JavaThread>();

        public Builder(long id, long startTimeUs, long endTimeUs, long downloadingTimeUS) {
            this.myId = id;
            this.myStartTimeUs = startTimeUs;
            this.myEndTimeUs = endTimeUs;
            this.myDownloadingTimeUs = downloadingTimeUS;
        }

        @NotNull
        public Builder setUrl(@NotNull String url) {
            this.myUrl = url;
            return this;
        }

        @NotNull
        public Builder setMethod(@NotNull String method) {
            this.myMethod = method;
            return this;
        }

        @NotNull
        public Builder setTrace(@NotNull String trace) {
            this.myTrace = trace;
            return this;
        }

        @NotNull
        public Builder addJavaThread(@NotNull JavaThread thread) {
            if (!this.myThreads.stream().anyMatch(t -> t.getId() == thread.getId())) {
                this.myThreads.add(thread);
            }
            return this;
        }

        @NotNull
        public Builder setResponseFields(@NotNull String responseFields) {
            this.myResponseFields = responseFields;
            return this;
        }

        @NotNull
        public Builder setResponsePayloadId(@NotNull String payloadId) {
            this.myResponsePayloadId = payloadId;
            return this;
        }

        @NotNull
        public Builder setRequestFields(@NotNull String requestFields) {
            this.myRequestFields = requestFields;
            return this;
        }

        @NotNull
        public HttpData build() {
            return new HttpData(this);
        }
    }

    public static final class JavaThread {
        private final long myId;
        @NotNull
        private final String myName;

        public JavaThread(long id, @NotNull String name) {
            this.myId = id;
            this.myName = name;
        }

        public long getId() {
            return this.myId;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }
    }

    public static final class ContentType {
        @NotNull
        private final String myContentType;

        public ContentType(@NotNull String contentType) {
            this.myContentType = contentType;
        }

        @NotNull
        public String getMimeType() {
            return this.myContentType.split(";")[0];
        }

        @Nullable
        public String guessFileExtension() {
            for (Map.Entry entry : CONTENT_EXTENSIONS_MAP.entrySet()) {
                if (!this.myContentType.contains((CharSequence)entry.getKey())) continue;
                return (String)entry.getValue();
            }
            return null;
        }

        @NotNull
        public String getContentType() {
            return this.myContentType;
        }

        public String toString() {
            return this.getContentType();
        }
    }

    public static final class StackTrace {
        private final ImmutableList<CodeLocation> myLocations;
        private final String myTrace;

        private StackTrace(@NotNull String trace) {
            this.myTrace = trace;
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (String line : trace.split("\\n")) {
                if (line.trim().isEmpty()) continue;
                builder.add((Object)new StackFrameParser(line).toCodeLocation());
            }
            this.myLocations = builder.build();
        }

        @NotNull
        public ImmutableList<CodeLocation> getCodeLocations() {
            return this.myLocations;
        }

        @VisibleForTesting
        @NotNull
        public String getTrace() {
            return this.myTrace;
        }
    }
}

