/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.network.HttpData;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpDataFetcher
implements Updatable {
    private static final long FETCH_FREQUENCY = TimeUnit.MILLISECONDS.toNanos(250L);
    private final AspectObserver myAspectObserver = new AspectObserver();
    @NotNull
    private final NetworkConnectionsModel myConnectionsModel;
    @NotNull
    private final Range myRange;
    @NotNull
    private final List<Listener> myListeners = new ArrayList<Listener>();
    @Nullable
    private List<HttpData> myDataList;
    private long myAccumNs;

    public HttpDataFetcher(@NotNull NetworkConnectionsModel connectionsModel, @NotNull Range range) {
        this.myConnectionsModel = connectionsModel;
        this.myRange = range;
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::pollImmediately);
        this.pollImmediately();
    }

    public void addListener(@NotNull Listener listener) {
        this.myListeners.add(listener);
        if (this.myDataList != null) {
            this.fireListeners(this.myDataList);
        }
    }

    public void update(long elapsedNs) {
        this.myAccumNs += elapsedNs;
        if (this.myAccumNs < FETCH_FREQUENCY && this.myDataList != null) {
            return;
        }
        this.myAccumNs = 0L;
        if (this.myDataList == null || this.stillDownloading(this.myDataList)) {
            this.myDataList = !this.myRange.isEmpty() ? this.myConnectionsModel.getData(this.myRange) : new ArrayList<HttpData>();
            this.fireListeners(this.myDataList);
        }
    }

    private void pollImmediately() {
        this.myDataList = null;
        this.update(0L);
    }

    private void fireListeners(@NotNull List<HttpData> dataList) {
        for (Listener l : this.myListeners) {
            l.onUpdated(dataList);
        }
    }

    private boolean stillDownloading(@NotNull List<HttpData> dataList) {
        for (HttpData data : dataList) {
            if (data.getEndTimeUs() != 0L) continue;
            return true;
        }
        return false;
    }

    public static interface Listener {
        public void onUpdated(@NotNull List<HttpData> var1);
    }
}

