/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.NetworkTrafficFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkTrafficDataSeries;
import com.android.tools.profilers.network.NetworkUsage;
import org.jetbrains.annotations.NotNull;

public class NetworkMonitor
extends ProfilerMonitor {
    private static final BaseAxisFormatter BANDWIDTH_AXIS_FORMATTER_L1 = new NetworkTrafficFormatter(1, 2, 5);
    private final NetworkUsage myNetworkUsage;
    private final NetworkLegends myLegends;
    private final AxisComponentModel myTrafficAxis;
    private final NetworkLegends myTooltipLegends;

    public NetworkMonitor(@NotNull StudioProfilers profilers) {
        super(profilers);
        this.myNetworkUsage = new NetworkUsage(profilers);
        this.myTrafficAxis = new AxisComponentModel(this.myNetworkUsage.getTrafficRange(), BANDWIDTH_AXIS_FORMATTER_L1);
        this.myTrafficAxis.setClampToMajorTicks(true);
        this.myLegends = new NetworkLegends(this.myNetworkUsage, this.getTimeline().getDataRange(), false);
        this.myTooltipLegends = new NetworkLegends(this.myNetworkUsage, this.getTimeline().getTooltipRange(), true);
    }

    @Override
    @NotNull
    public String getName() {
        return "NETWORK";
    }

    @Override
    public void exit() {
        this.myProfilers.getUpdater().unregister((Updatable)this.myNetworkUsage);
        this.myProfilers.getUpdater().unregister((Updatable)this.myTrafficAxis);
        this.myProfilers.getUpdater().unregister((Updatable)this.myLegends);
        this.myProfilers.getUpdater().unregister((Updatable)this.myTooltipLegends);
    }

    @Override
    public void enter() {
        this.myProfilers.getUpdater().register((Updatable)this.myNetworkUsage);
        this.myProfilers.getUpdater().register((Updatable)this.myTrafficAxis);
        this.myProfilers.getUpdater().register((Updatable)this.myLegends);
        this.myProfilers.getUpdater().register((Updatable)this.myTooltipLegends);
    }

    @Override
    public void expand() {
        this.myProfilers.setStage(new NetworkProfilerStage(this.myProfilers));
    }

    public AxisComponentModel getTrafficAxis() {
        return this.myTrafficAxis;
    }

    public NetworkUsage getNetworkUsage() {
        return this.myNetworkUsage;
    }

    public NetworkLegends getLegends() {
        return this.myLegends;
    }

    public NetworkLegends getTooltipLegends() {
        return this.myTooltipLegends;
    }

    public static class NetworkLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myRxLegend;
        @NotNull
        private final SeriesLegend myTxLegend;

        public NetworkLegends(@NotNull NetworkUsage usage, @NotNull Range range, boolean hightlight) {
            super(hightlight ? 0 : 100);
            this.myTxLegend = new SeriesLegend(usage.getTxSeries(), BANDWIDTH_AXIS_FORMATTER_L1, range, NetworkTrafficDataSeries.Type.BYTES_SENT.getLabel(hightlight), Interpolatable.SegmentInterpolator);
            this.myRxLegend = new SeriesLegend(usage.getRxSeries(), BANDWIDTH_AXIS_FORMATTER_L1, range, NetworkTrafficDataSeries.Type.BYTES_RECEIVED.getLabel(hightlight), Interpolatable.SegmentInterpolator);
            this.add((Legend)this.myTxLegend);
            this.add((Legend)this.myRxLegend);
        }

        @NotNull
        public SeriesLegend getRxLegend() {
            return this.myRxLegend;
        }

        @NotNull
        public SeriesLegend getTxLegend() {
            return this.myTxLegend;
        }
    }
}

