/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class NetworkOpenConnectionsDataSeries
implements DataSeries<Long> {
    @NotNull
    private NetworkServiceGrpc.NetworkServiceBlockingStub myClient;
    private final int myProcessId;
    private final Common.Session mySession;

    public NetworkOpenConnectionsDataSeries(@NotNull NetworkServiceGrpc.NetworkServiceBlockingStub client, int id, Common.Session session) {
        this.myClient = client;
        this.myProcessId = id;
        this.mySession = session;
    }

    public List<SeriesData<Long>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        NetworkProfiler.NetworkDataRequest.Builder dataRequestBuilder = NetworkProfiler.NetworkDataRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setType(NetworkProfiler.NetworkDataRequest.Type.CONNECTIONS).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        NetworkProfiler.NetworkDataResponse response = this.myClient.getData(dataRequestBuilder.build());
        for (NetworkProfiler.NetworkProfilerData data : response.getDataList()) {
            long xTimestamp = TimeUnit.NANOSECONDS.toMicros(data.getBasicInfo().getEndTimestamp());
            NetworkProfiler.ConnectionData connectionData = data.getConnectionData();
            seriesData.add((SeriesData<Long>)new SeriesData(xTimestamp, (Object)connectionData.getConnectionNumber()));
        }
        return seriesData;
    }
}

