/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.NetworkTrafficFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.network.DetailedNetworkUsage;
import com.android.tools.profilers.network.HttpData;
import com.android.tools.profilers.network.HttpDataFetcher;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.NetworkProfilerAspect;
import com.android.tools.profilers.network.NetworkRadioDataSeries;
import com.android.tools.profilers.network.NetworkTrafficDataSeries;
import com.android.tools.profilers.network.RpcNetworkConnectionsModel;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf3jarjar.ByteString;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final BaseAxisFormatter TRAFFIC_AXIS_FORMATTER = new NetworkTrafficFormatter(1, 5, 5);
    private static final BaseAxisFormatter CONNECTIONS_AXIS_FORMATTER = new SingleUnitAxisFormatter(1, 5, 1, "");
    @Nullable
    private HttpData mySelectedConnection;
    private AspectObserver myAspectObserver = new AspectObserver();
    private AspectModel<NetworkProfilerAspect> myAspect = new AspectModel();
    StateChartModel<NetworkRadioDataSeries.RadioState> myRadioState;
    private final NetworkConnectionsModel myConnectionsModel = new RpcNetworkConnectionsModel(this.getStudioProfilers().getClient().getProfilerClient(), this.getStudioProfilers().getClient().getNetworkClient(), this.getStudioProfilers().getProcessId(), this.getStudioProfilers().getSession());
    private final DetailedNetworkUsage myDetailedNetworkUsage;
    private final NetworkStageLegends myLegends;
    private final NetworkStageLegends myTooltipLegends;
    private final AxisComponentModel myTrafficAxis;
    private final AxisComponentModel myConnectionsAxis;
    private final EventMonitor myEventMonitor;
    private final StackTraceModel myStackTraceModel;
    private final SelectionModel mySelectionModel;
    private final HttpDataFetcher myHttpDataFetcher;

    public NetworkProfilerStage(final StudioProfilers profilers) {
        super(profilers);
        ProfilerTimeline timeline = profilers.getTimeline();
        NetworkRadioDataSeries radioDataSeries = new NetworkRadioDataSeries(profilers.getClient().getNetworkClient(), profilers.getProcessId(), this.getStudioProfilers().getSession());
        this.myRadioState = new StateChartModel();
        this.myRadioState.addSeries(new RangedSeries(timeline.getViewRange(), (DataSeries)radioDataSeries));
        this.myDetailedNetworkUsage = new DetailedNetworkUsage(profilers);
        this.myTrafficAxis = new AxisComponentModel(this.myDetailedNetworkUsage.getTrafficRange(), TRAFFIC_AXIS_FORMATTER);
        this.myTrafficAxis.setClampToMajorTicks(true);
        this.myConnectionsAxis = new AxisComponentModel(this.myDetailedNetworkUsage.getConnectionsRange(), CONNECTIONS_AXIS_FORMATTER);
        this.myConnectionsAxis.setClampToMajorTicks(true);
        this.myLegends = new NetworkStageLegends(this.myDetailedNetworkUsage, timeline.getDataRange(), false);
        this.myTooltipLegends = new NetworkStageLegends(this.myDetailedNetworkUsage, timeline.getTooltipRange(), true);
        this.myEventMonitor = new EventMonitor(profilers);
        this.myStackTraceModel = new StackTraceModel(profilers.getIdeServices().getCodeNavigator());
        this.mySelectionModel = new SelectionModel(timeline.getSelectionRange(), timeline.getViewRange());
        profilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, () -> this.mySelectionModel.setSelectionEnabled(profilers.isAgentAttached()));
        this.mySelectionModel.setSelectionEnabled(profilers.isAgentAttached());
        this.mySelectionModel.addListener(new SelectionListener(){

            public void selectionCreated() {
                NetworkProfilerStage.this.setProfilerMode(ProfilerMode.EXPANDED);
                profilers.getIdeServices().getFeatureTracker().trackSelectRange();
            }

            public void selectionCleared() {
                NetworkProfilerStage.this.setProfilerMode(ProfilerMode.NORMAL);
            }
        });
        this.myHttpDataFetcher = new HttpDataFetcher(this.myConnectionsModel, timeline.getSelectionRange());
    }

    @NotNull
    public NetworkConnectionsModel getConnectionsModel() {
        return this.myConnectionsModel;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    @NotNull
    public StackTraceModel getStackTraceModel() {
        return this.myStackTraceModel;
    }

    @NotNull
    public HttpDataFetcher getHttpDataFetcher() {
        return this.myHttpDataFetcher;
    }

    public boolean setSelectedConnection(@Nullable HttpData data) {
        if (Objects.equals(this.mySelectedConnection, data)) {
            return false;
        }
        if (data != null && StringUtil.isNotEmpty((String)data.getResponsePayloadId()) && data.getResponsePayloadFile() == null) {
            ByteString payload = this.getConnectionsModel().requestResponsePayload(data);
            try {
                File file = this.getConnectionPayload(payload, data);
                data.setResponsePayloadFile(file);
            }
            catch (IOException e) {
                return false;
            }
        }
        this.mySelectedConnection = data;
        this.getAspect().changed((Enum)NetworkProfilerAspect.SELECTED_CONNECTION);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectNetworkRequest();
        return true;
    }

    @VisibleForTesting
    File getConnectionPayload(@NotNull ByteString payload, @NotNull HttpData data) throws IOException {
        String extension = data.getContentType() == null ? null : data.getContentType().guessFileExtension();
        File file = FileUtil.createTempFile((String)data.getResponsePayloadId(), (String)StringUtil.notNullize((String)extension), (boolean)true);
        byte[] bytes = payload.toByteArray();
        String contentEncoding = data.getResponseField("content-encoding");
        if (contentEncoding != null && contentEncoding.toLowerCase().contains("gzip")) {
            try (GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(bytes));){
                bytes = FileUtil.loadBytes((InputStream)inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FileUtil.writeToFile((File)file, (byte[])bytes);
        file.setReadOnly();
        return file;
    }

    @Nullable
    public HttpData getSelectedConnection() {
        return this.mySelectedConnection;
    }

    @NotNull
    public AspectModel<NetworkProfilerAspect> getAspect() {
        return this.myAspect;
    }

    public StateChartModel<NetworkRadioDataSeries.RadioState> getRadioState() {
        return this.myRadioState;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register(this.myRadioState);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myDetailedNetworkUsage);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myTrafficAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myConnectionsAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myTooltipLegends);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myHttpDataFetcher);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister(this.myRadioState);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myDetailedNetworkUsage);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myTrafficAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myConnectionsAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myTooltipLegends);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myHttpDataFetcher);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.mySelectionModel.clearListeners();
    }

    @NotNull
    public String getName() {
        return "NETWORK";
    }

    @NotNull
    public DetailedNetworkUsage getDetailedNetworkUsage() {
        return this.myDetailedNetworkUsage;
    }

    @NotNull
    public AxisComponentModel getTrafficAxis() {
        return this.myTrafficAxis;
    }

    @NotNull
    public AxisComponentModel getConnectionsAxis() {
        return this.myConnectionsAxis;
    }

    @NotNull
    public NetworkStageLegends getLegends() {
        return this.myLegends;
    }

    @NotNull
    public NetworkStageLegends getTooltipLegends() {
        return this.myTooltipLegends;
    }

    @NotNull
    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    public static class NetworkStageLegends
    extends LegendComponentModel {
        private final SeriesLegend myRxLegend;
        private final SeriesLegend myTxLegend;
        private final SeriesLegend myConnectionLegend;

        public NetworkStageLegends(DetailedNetworkUsage usage, Range range, boolean tooltip) {
            super(100);
            this.myRxLegend = new SeriesLegend(usage.getRxSeries(), TRAFFIC_AXIS_FORMATTER, range, NetworkTrafficDataSeries.Type.BYTES_RECEIVED.getLabel(tooltip), Interpolatable.SegmentInterpolator);
            this.myTxLegend = new SeriesLegend(usage.getTxSeries(), TRAFFIC_AXIS_FORMATTER, range, NetworkTrafficDataSeries.Type.BYTES_SENT.getLabel(tooltip), Interpolatable.SegmentInterpolator);
            this.myConnectionLegend = new SeriesLegend(usage.getConnectionSeries(), CONNECTIONS_AXIS_FORMATTER, range, Interpolatable.SteppedLineInterpolator);
            this.add((Legend)this.myRxLegend);
            this.add((Legend)this.myTxLegend);
            this.add((Legend)this.myConnectionLegend);
        }

        public SeriesLegend getRxLegend() {
            return this.myRxLegend;
        }

        public SeriesLegend getTxLegend() {
            return this.myTxLegend;
        }

        public SeriesLegend getConnectionLegend() {
            return this.myConnectionLegend;
        }
    }
}

