/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.FlatTabbedPane;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.SelectionComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.InfoMessagePanel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.network.ConnectionDetailsView;
import com.android.tools.profilers.network.ConnectionsView;
import com.android.tools.profilers.network.DetailedNetworkUsage;
import com.android.tools.profilers.network.NetworkProfilerAspect;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkRadioView;
import com.android.tools.profilers.network.NetworkStageTooltipView;
import com.android.tools.profilers.network.ThreadsView;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class NetworkProfilerStageView
extends StageView<NetworkProfilerStage> {
    private static final String CARD_CONNECTIONS = "Connections";
    private static final String CARD_INFO = "Info";
    private final ConnectionsView myConnectionsView;
    private final ThreadsView myThreadsView;
    private final ConnectionDetailsView myConnectionDetails;
    private final JPanel myConnectionsPanel;
    private final NetworkStageTooltipView myTooltipView;

    public NetworkProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull NetworkProfilerStage stage) {
        super(profilersView, stage);
        ((NetworkProfilerStage)this.getStage()).getAspect().addDependency((AspectObserver)this).onChange((Enum)NetworkProfilerAspect.SELECTED_CONNECTION, this::updateConnectionDetailsView);
        this.myConnectionDetails = new ConnectionDetailsView(this);
        this.myConnectionDetails.setMinimumSize(new Dimension(JBUI.scale((int)450), (int)this.myConnectionDetails.getMinimumSize().getHeight()));
        this.myConnectionsView = new ConnectionsView(this);
        this.myTooltipView = new NetworkStageTooltipView(stage);
        this.myThreadsView = new ThreadsView(this);
        JBSplitter leftSplitter = new JBSplitter(true);
        leftSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        leftSplitter.setFirstComponent((JComponent)this.buildMonitorUi());
        this.myConnectionsPanel = new JPanel(new CardLayout());
        if (stage.getStudioProfilers().getIdeServices().getFeatureConfig().isNetworkThreadViewEnabled()) {
            FlatTabbedPane connectionsTab = new FlatTabbedPane();
            JBScrollPane connectionScrollPane = new JBScrollPane((Component)this.myConnectionsView.getComponent());
            connectionScrollPane.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
            JBScrollPane threadsViewScrollPane = new JBScrollPane((Component)this.myThreadsView.getComponent());
            threadsViewScrollPane.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
            connectionsTab.addTab("Connection View", (Component)connectionScrollPane);
            connectionsTab.addTab("Thread View", (Component)threadsViewScrollPane);
            this.myConnectionsPanel.add((Component)connectionsTab, CARD_CONNECTIONS);
        } else {
            JBScrollPane connectionScrollPane = new JBScrollPane((Component)this.myConnectionsView.getComponent());
            connectionScrollPane.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
            this.myConnectionsPanel.add((Component)connectionScrollPane, CARD_CONNECTIONS);
        }
        InfoMessagePanel.UrlData learnMoreData = new InfoMessagePanel.UrlData("Learn More", "https://developer.android.com/r/studio-ui/network-profiler-troubleshoot-connections.html");
        InfoMessagePanel infoPanel = new InfoMessagePanel("Network Profiling Data Unavailable", "There is no information for the network traffic you've selected.", learnMoreData);
        infoPanel.setName(CARD_INFO);
        this.myConnectionsPanel.add((Component)infoPanel, CARD_INFO);
        this.myConnectionsPanel.setVisible(false);
        leftSplitter.setSecondComponent((JComponent)this.myConnectionsPanel);
        this.getTimeline().getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> {
            CardLayout cardLayout = (CardLayout)this.myConnectionsPanel.getLayout();
            cardLayout.show(this.myConnectionsPanel, this.selectionHasTrafficUsageWithNoConnection() ? CARD_INFO : CARD_CONNECTIONS);
        });
        JBSplitter splitter = new JBSplitter(false, 0.6f);
        splitter.setFirstComponent((JComponent)leftSplitter);
        splitter.setSecondComponent((JComponent)this.myConnectionDetails);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.getDivider().setBorder(AdtUiUtils.DEFAULT_VERTICAL_BORDERS);
        this.getComponent().add((Component)splitter, "Center");
        this.updateConnectionDetailsView();
    }

    public ConnectionsView getConnectionsView() {
        return this.myConnectionsView;
    }

    @NotNull
    private JPanel buildMonitorUi() {
        StudioProfilers profilers = ((NetworkProfilerStage)this.getStage()).getStudioProfilers();
        ProfilerTimeline timeline = profilers.getTimeline();
        TabularLayout layout = new TabularLayout("*");
        JBPanel panel = new JBPanel((LayoutManager)layout);
        panel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        ProfilerScrollbar sb = new ProfilerScrollbar(timeline, (JComponent)panel);
        panel.add((Component)((Object)sb), new TabularLayout.Constraint(4, 0));
        JComponent timeAxis = this.buildTimeAxis(profilers);
        panel.add((Component)timeAxis, new TabularLayout.Constraint(3, 0));
        EventMonitorView eventsView = new EventMonitorView(this.getProfilersView(), ((NetworkProfilerStage)this.getStage()).getEventMonitor());
        JComponent eventsComponent = eventsView.getComponent();
        panel.add((Component)eventsComponent, new TabularLayout.Constraint(0, 0));
        panel.add((Component)new NetworkRadioView(this).getComponent(), new TabularLayout.Constraint(1, 0));
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
        JLabel label = new JLabel(((NetworkProfilerStage)this.getStage()).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        lineChartPanel.setBorder(BorderFactory.createEmptyBorder(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0));
        DetailedNetworkUsage usage = ((NetworkProfilerStage)this.getStage()).getDetailedNetworkUsage();
        LineChart lineChart = new LineChart((LineChartModel)usage);
        LineConfig receivedConfig = new LineConfig(ProfilerColors.NETWORK_RECEIVING_COLOR).setLegendIconType(LegendConfig.IconType.LINE);
        lineChart.configure(usage.getRxSeries(), receivedConfig);
        LineConfig sentConfig = new LineConfig(ProfilerColors.NETWORK_SENDING_COLOR).setLegendIconType(LegendConfig.IconType.LINE);
        lineChart.configure(usage.getTxSeries(), sentConfig);
        LineConfig connectionConfig = new LineConfig(ProfilerColors.NETWORK_CONNECTIONS_COLOR).setLegendIconType(LegendConfig.IconType.DASHED_LINE).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE);
        lineChart.configure(usage.getConnectionSeries(), connectionConfig);
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, "Center");
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((NetworkProfilerStage)this.getStage()).getTrafficAxis(), AxisComponent.AxisOrientation.RIGHT);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(true);
        leftAxis.setShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        AxisComponent rightAxis = new AxisComponent(((NetworkProfilerStage)this.getStage()).getConnectionsAxis(), AxisComponent.AxisOrientation.LEFT);
        rightAxis.setShowAxisLine(false);
        rightAxis.setShowMax(true);
        rightAxis.setShowUnitAtMax(true);
        rightAxis.setHideTickAtMin(true);
        rightAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        rightAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)rightAxis, "East");
        NetworkProfilerStage.NetworkStageLegends legends = ((NetworkProfilerStage)this.getStage()).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.configure((Legend)legends.getRxLegend(), new LegendConfig(lineChart.getLineConfig(usage.getRxSeries())));
        legend.configure((Legend)legends.getTxLegend(), new LegendConfig(lineChart.getLineConfig(usage.getTxSeries())));
        legend.configure((Legend)legends.getConnectionLegend(), new LegendConfig(lineChart.getLineConfig(usage.getConnectionSeries())));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        legendPanel.add((Component)legend, "East");
        SelectionComponent selection = new SelectionComponent(((NetworkProfilerStage)this.getStage()).getSelectionModel());
        ((NetworkProfilerStage)this.getStage()).getSelectionModel().addListener(new SelectionListener(){

            public void selectionCreated() {
                NetworkProfilerStageView.this.myConnectionsPanel.setVisible(true);
            }

            public void selectionCleared() {
                NetworkProfilerStageView.this.myConnectionsPanel.setVisible(false);
                NetworkProfilerStageView.this.myConnectionDetails.setHttpData(null);
            }
        });
        RangeTooltipComponent tooltip = new RangeTooltipComponent(timeline.getTooltipRange(), timeline.getViewRange(), timeline.getDataRange(), this.myTooltipView.createComponent());
        tooltip.registerListenersOn((Component)selection);
        monitorPanel.add((Component)tooltip, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)selection, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)axisPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
        layout.setRowSizing(2, "*");
        panel.add((Component)monitorPanel, new TabularLayout.Constraint(2, 0));
        return panel;
    }

    private void updateConnectionDetailsView() {
        this.myConnectionDetails.setHttpData(((NetworkProfilerStage)this.getStage()).getSelectedConnection());
    }

    @Override
    @NotNull
    public JComponent getToolbar() {
        return new JPanel(new BorderLayout());
    }

    private boolean selectionHasTrafficUsageWithNoConnection() {
        boolean hasNoConnection;
        Range range = this.getTimeline().getSelectionRange();
        boolean bl = hasNoConnection = !range.isEmpty() && ((NetworkProfilerStage)this.getStage()).getConnectionsModel().getData(range).isEmpty();
        if (hasNoConnection) {
            DetailedNetworkUsage detailedNetworkUsage = ((NetworkProfilerStage)this.getStage()).getDetailedNetworkUsage();
            return NetworkProfilerStageView.hasTrafficUsage(detailedNetworkUsage.getRxSeries(), range) || NetworkProfilerStageView.hasTrafficUsage(detailedNetworkUsage.getTxSeries(), range);
        }
        return false;
    }

    private static boolean hasTrafficUsage(RangedContinuousSeries series, Range range) {
        int maxIndex;
        List list = series.getDataSeries().getDataForXRange(range);
        if (list.stream().anyMatch(data -> (double)data.x >= range.getMin() && (double)data.x <= range.getMax() && (Long)data.value > 0L)) {
            return true;
        }
        Function<Long, Integer> getInsertPoint = time -> {
            int index = Collections.binarySearch(list, new SeriesData(time.longValue(), (Object)0L), (o1, o2) -> Long.compare(o1.x, o2.x));
            return index < 0 ? -(index + 1) : index;
        };
        int minIndex = getInsertPoint.apply((long)range.getMin());
        if (minIndex == (maxIndex = getInsertPoint.apply((long)range.getMax()).intValue())) {
            return minIndex > 0 && (Long)((SeriesData)list.get((int)(minIndex - 1))).value > 0L && minIndex < list.size() && (Long)((SeriesData)list.get((int)minIndex)).value > 0L;
        }
        return false;
    }
}

