/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class NetworkRadioDataSeries
implements DataSeries<RadioState> {
    @NotNull
    private final NetworkServiceGrpc.NetworkServiceBlockingStub myClient;
    private final int myProcessId;
    private final Common.Session mySession;

    public NetworkRadioDataSeries(@NotNull NetworkServiceGrpc.NetworkServiceBlockingStub client, int processId, Common.Session session) {
        this.myClient = client;
        this.myProcessId = processId;
        this.mySession = session;
    }

    @NotNull
    public List<SeriesData<RadioState>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        NetworkProfiler.NetworkDataRequest.Builder dataRequestBuilder = NetworkProfiler.NetworkDataRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setType(NetworkProfiler.NetworkDataRequest.Type.CONNECTIVITY).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        NetworkProfiler.NetworkDataResponse response = this.myClient.getData(dataRequestBuilder.build());
        ArrayList<SeriesData<RadioState>> seriesData = new ArrayList<SeriesData<RadioState>>();
        block8: for (NetworkProfiler.NetworkProfilerData data : response.getDataList()) {
            long timestampUs = TimeUnit.NANOSECONDS.toMicros(data.getBasicInfo().getEndTimestamp());
            switch (data.getConnectivityData().getDefaultNetworkType()) {
                case WIFI: {
                    seriesData.add((SeriesData<RadioState>)new SeriesData(timestampUs, (Object)RadioState.WIFI));
                    continue block8;
                }
                case MOBILE: {
                    switch (data.getConnectivityData().getRadioState()) {
                        case HIGH: {
                            seriesData.add((SeriesData<RadioState>)new SeriesData(timestampUs, (Object)RadioState.HIGH));
                            continue block8;
                        }
                        case LOW: {
                            seriesData.add((SeriesData<RadioState>)new SeriesData(timestampUs, (Object)RadioState.LOW));
                            continue block8;
                        }
                    }
                    seriesData.add((SeriesData<RadioState>)new SeriesData(timestampUs, (Object)RadioState.NONE));
                    continue block8;
                }
            }
            seriesData.add((SeriesData<RadioState>)new SeriesData(timestampUs, (Object)RadioState.NONE));
        }
        return seriesData;
    }

    public static enum RadioState {
        WIFI,
        LOW,
        HIGH,
        NONE;

    }
}

