/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.network.NetworkProfilerStage;
import java.awt.Component;

class NetworkStageTooltipView
extends ProfilerTooltipView {
    private final NetworkProfilerStage myStage;

    NetworkStageTooltipView(NetworkProfilerStage stage) {
        super(stage.getStudioProfilers().getTimeline(), "Network Traffic");
        this.myStage = stage;
    }

    @Override
    protected Component createTooltip() {
        NetworkProfilerStage.NetworkStageLegends legends = this.myStage.getTooltipLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setVerticalPadding(0).setOrientation(LegendComponent.Orientation.VERTICAL).build();
        legend.configure((Legend)legends.getRxLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.NETWORK_RECEIVING_COLOR));
        legend.configure((Legend)legends.getTxLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.NETWORK_SENDING_COLOR));
        legend.configure((Legend)legends.getConnectionLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.NETWORK_CONNECTIONS_COLOR));
        return legend;
    }
}

