/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class NetworkTrafficDataSeries
implements DataSeries<Long> {
    @NotNull
    private NetworkServiceGrpc.NetworkServiceBlockingStub myClient;
    private final int myProcessId;
    private final Common.Session mySession;
    private final Type myType;

    public NetworkTrafficDataSeries(@NotNull NetworkServiceGrpc.NetworkServiceBlockingStub client, int id, Common.Session session, Type type) {
        this.myClient = client;
        this.myProcessId = id;
        this.mySession = session;
        this.myType = type;
    }

    public List<SeriesData<Long>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        NetworkProfiler.NetworkDataRequest.Builder dataRequestBuilder = NetworkProfiler.NetworkDataRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setType(NetworkProfiler.NetworkDataRequest.Type.SPEED).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        NetworkProfiler.NetworkDataResponse response = this.myClient.getData(dataRequestBuilder.build());
        for (NetworkProfiler.NetworkProfilerData data : response.getDataList()) {
            long xTimestamp = TimeUnit.NANOSECONDS.toMicros(data.getBasicInfo().getEndTimestamp());
            NetworkProfiler.SpeedData speedData = data.getSpeedData();
            seriesData.add((SeriesData<Long>)new SeriesData(xTimestamp, (Object)this.myType.getBytes(speedData)));
        }
        return seriesData;
    }

    public static enum Type {
        BYTES_RECEIVED("Receiving", "Received"){

            @Override
            long getBytes(@NotNull NetworkProfiler.SpeedData data) {
                return data.getReceived();
            }
        }
        ,
        BYTES_SENT("Sending", "Sent"){

            @Override
            long getBytes(@NotNull NetworkProfiler.SpeedData data) {
                return data.getSent();
            }
        };

        private final String myLabel;
        private final String myTooltipLabel;

        private Type(String label, String tooltipLabel) {
            this.myLabel = label;
            this.myTooltipLabel = tooltipLabel;
        }

        @NotNull
        public String getLabel(boolean tooltip) {
            return tooltip ? this.myTooltipLabel : this.myLabel;
        }

        abstract long getBytes(@NotNull NetworkProfiler.SpeedData var1);
    }
}

