/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.network.NetworkTrafficDataSeries;
import org.jetbrains.annotations.NotNull;

public class NetworkUsage
extends LineChartModel {
    @NotNull
    private final RangedContinuousSeries myRxSeries;
    @NotNull
    private final RangedContinuousSeries myTxSeries;
    @NotNull
    private final Range myTrafficRange;

    public NetworkUsage(@NotNull StudioProfilers profilers) {
        Range viewRange = profilers.getTimeline().getViewRange();
        this.myTrafficRange = new Range(0.0, 4.0);
        this.myRxSeries = new RangedContinuousSeries(NetworkTrafficDataSeries.Type.BYTES_RECEIVED.getLabel(false), viewRange, this.myTrafficRange, (DataSeries)this.createSeries(profilers, NetworkTrafficDataSeries.Type.BYTES_RECEIVED));
        this.myTxSeries = new RangedContinuousSeries(NetworkTrafficDataSeries.Type.BYTES_SENT.getLabel(false), viewRange, this.myTrafficRange, (DataSeries)this.createSeries(profilers, NetworkTrafficDataSeries.Type.BYTES_SENT));
        this.add(this.myRxSeries);
        this.add(this.myTxSeries);
    }

    @NotNull
    public NetworkTrafficDataSeries createSeries(@NotNull StudioProfilers profilers, @NotNull NetworkTrafficDataSeries.Type trafficType) {
        NetworkServiceGrpc.NetworkServiceBlockingStub client = profilers.getClient().getNetworkClient();
        return new NetworkTrafficDataSeries(client, profilers.getProcessId(), profilers.getSession(), trafficType);
    }

    @NotNull
    public RangedContinuousSeries getRxSeries() {
        return this.myRxSeries;
    }

    @NotNull
    public RangedContinuousSeries getTxSeries() {
        return this.myTxSeries;
    }

    @NotNull
    public Range getTrafficRange() {
        return this.myTrafficRange;
    }
}

