/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import com.android.tools.profilers.network.HttpData;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.google.protobuf3jarjar.ByteString;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class RpcNetworkConnectionsModel
implements NetworkConnectionsModel {
    @NotNull
    private final ProfilerServiceGrpc.ProfilerServiceBlockingStub myProfilerService;
    private final NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkService;
    private final int myPid;
    private final Common.Session mySession;

    public RpcNetworkConnectionsModel(@NotNull ProfilerServiceGrpc.ProfilerServiceBlockingStub profilerService, @NotNull NetworkServiceGrpc.NetworkServiceBlockingStub networkService, int pid, Common.Session session) {
        this.myProfilerService = profilerService;
        this.myNetworkService = networkService;
        this.myPid = pid;
        this.mySession = session;
    }

    @Override
    @NotNull
    public List<HttpData> getData(@NotNull Range timeCurrentRangeUs) {
        NetworkProfiler.HttpRangeRequest request = NetworkProfiler.HttpRangeRequest.newBuilder().setProcessId(this.myPid).setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax())).build();
        NetworkProfiler.HttpRangeResponse response = this.myNetworkService.getHttpRange(request);
        ArrayList<HttpData> httpDataList = new ArrayList<HttpData>(response.getDataList().size());
        for (NetworkProfiler.HttpConnectionData connection : response.getDataList()) {
            long startTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getStartTimestamp());
            long endTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getEndTimestamp());
            long downloadTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getDownloadingTimestamp());
            HttpData.Builder httpBuilder = new HttpData.Builder(connection.getConnId(), startTimeUs, endTimeUs, downloadTimeUs);
            this.requestHttpRequest(connection.getConnId(), httpBuilder);
            this.requestAccessingThreads(connection.getConnId(), httpBuilder);
            if (connection.getEndTimestamp() != 0L) {
                this.requestHttpResponse(connection.getConnId(), httpBuilder);
                this.requestHttpResponseBody(connection.getConnId(), httpBuilder);
            }
            httpDataList.add(httpBuilder.build());
        }
        return httpDataList;
    }

    private void requestHttpRequest(long connectionId, @NotNull HttpData.Builder httpBuilder) {
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(connectionId).setSession(this.mySession).setType(NetworkProfiler.HttpDetailsRequest.Type.REQUEST).build();
        NetworkProfiler.HttpDetailsResponse.Request result = this.myNetworkService.getHttpDetails(request).getRequest();
        httpBuilder.setUrl(result.getUrl());
        httpBuilder.setMethod(result.getMethod());
        httpBuilder.setTrace(result.getTrace());
        httpBuilder.setRequestFields(result.getFields());
    }

    private void requestHttpResponseBody(long connectionId, @NotNull HttpData.Builder httpBuilder) {
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(connectionId).setSession(this.mySession).setType(NetworkProfiler.HttpDetailsRequest.Type.RESPONSE_BODY).build();
        NetworkProfiler.HttpDetailsResponse response = this.myNetworkService.getHttpDetails(request);
        String payloadId = response.getResponseBody().getPayloadId();
        httpBuilder.setResponsePayloadId(payloadId);
    }

    @Override
    @NotNull
    public ByteString requestResponsePayload(@NotNull HttpData data) {
        if (StringUtil.isEmpty((String)data.getResponsePayloadId())) {
            return ByteString.EMPTY;
        }
        Profiler.BytesRequest request = Profiler.BytesRequest.newBuilder().setId(data.getResponsePayloadId()).setSession(this.mySession).build();
        Profiler.BytesResponse response = this.myProfilerService.getBytes(request);
        return response.getContents();
    }

    private void requestHttpResponse(long connectionId, @NotNull HttpData.Builder httpBuilder) {
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(connectionId).setSession(this.mySession).setType(NetworkProfiler.HttpDetailsRequest.Type.RESPONSE).build();
        NetworkProfiler.HttpDetailsResponse response = this.myNetworkService.getHttpDetails(request);
        httpBuilder.setResponseFields(response.getResponse().getFields());
    }

    private void requestAccessingThreads(long connectionId, @NotNull HttpData.Builder httpBuilder) {
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(connectionId).setSession(this.mySession).setType(NetworkProfiler.HttpDetailsRequest.Type.ACCESSING_THREADS).build();
        NetworkProfiler.HttpDetailsResponse response = this.myNetworkService.getHttpDetails(request);
        for (NetworkProfiler.JavaThread thread : response.getAccessingThreads().getThreadList()) {
            httpBuilder.addJavaThread(new HttpData.JavaThread(thread.getId(), thread.getName()));
        }
    }
}

