/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.network.HoverRowTable;
import com.android.tools.profilers.network.HttpData;
import com.android.tools.profilers.network.HttpDataFetcher;
import com.android.tools.profilers.network.NetworkProfilerAspect;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ThreadsView {
    private static final int STATE_HEIGHT = 15;
    private static final int SELECTION_OUTLINE_PADDING = 3;
    private static final int SELECTION_OUTLINE_BORDER = 2;
    private static final int ROW_HEIGHT = 25;
    @NotNull
    private final JTable myThreadsTable;
    @NotNull
    private final JLayeredPane myPanel;
    @NotNull
    private final AspectObserver myObserver;

    ThreadsView(@NotNull NetworkProfilerStageView stageView) {
        this.myThreadsTable = new HoverRowTable(new ThreadsTableModel(((NetworkProfilerStage)stageView.getStage()).getHttpDataFetcher()), ProfilerColors.DEFAULT_HOVER_COLOR);
        TimelineRenderer timelineRenderer = new TimelineRenderer(this.myThreadsTable, (NetworkProfilerStage)stageView.getStage());
        this.myThreadsTable.getColumnModel().getColumn(1).setCellRenderer(timelineRenderer);
        this.myThreadsTable.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myThreadsTable.setShowVerticalLines(true);
        this.myThreadsTable.setShowHorizontalLines(false);
        this.myThreadsTable.setTableHeader(null);
        this.myThreadsTable.setCellSelectionEnabled(false);
        this.myThreadsTable.setFocusable(false);
        this.myThreadsTable.setRowMargin(0);
        this.myThreadsTable.setRowHeight(25);
        this.myThreadsTable.setFocusTraversalKeys(0, null);
        this.myThreadsTable.setFocusTraversalKeys(1, null);
        this.myThreadsTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ThreadsView.this.myThreadsTable.getColumnModel().getColumn(0).setPreferredWidth((int)((double)ThreadsView.this.myThreadsTable.getWidth() * 1.0 / 8.0));
                ThreadsView.this.myThreadsTable.getColumnModel().getColumn(1).setPreferredWidth((int)((double)ThreadsView.this.myThreadsTable.getWidth() * 7.0 / 8.0));
            }
        });
        this.myPanel = new JLayeredPane();
        final JComponent tooltip = new TableTooltipView(this.myThreadsTable, (NetworkProfilerStage)stageView.getStage()).getComponent();
        this.myPanel.add((Component)this.myThreadsTable, (Object)0);
        this.myPanel.add((Component)tooltip, (Object)1);
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ThreadsView.this.myThreadsTable.setSize(ThreadsView.this.myPanel.getSize());
                tooltip.setSize(ThreadsView.this.myPanel.getSize());
            }
        });
        this.myObserver = new AspectObserver();
        ((NetworkProfilerStage)stageView.getStage()).getAspect().addDependency(this.myObserver).onChange((Enum)NetworkProfilerAspect.SELECTED_CONNECTION, () -> timelineRenderer.updateRows());
    }

    @NotNull
    JComponent getComponent() {
        return this.myPanel;
    }

    private static final class TableTooltipView
    extends MouseAdapter {
        @NotNull
        private final NetworkProfilerStage myStage;
        @NotNull
        private final JTable myTable;
        @NotNull
        private final JPanel myComponent;
        @NotNull
        private final TooltipComponent myTooltipComponent;
        @NotNull
        private final JLabel myLabel;

        TableTooltipView(@NotNull JTable table, @NotNull NetworkProfilerStage stage) {
            this.myTable = table;
            this.myStage = stage;
            this.myLabel = new JLabel();
            this.myLabel.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
            this.myLabel.setBorder(new EmptyBorder(5, 10, 5, 10));
            this.myLabel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
            this.myLabel.setFont(this.myLabel.getFont().deriveFont(11.0f));
            this.myLabel.setOpaque(true);
            this.myComponent = new JPanel((LayoutManager)new TabularLayout("*", "*"));
            this.myTooltipComponent = new TooltipComponent((Component)this.myLabel);
            this.myTooltipComponent.registerListenersOn((Component)this.myComponent);
            this.myTooltipComponent.setVisible(false);
            this.myComponent.add((Component)this.myTooltipComponent, new TabularLayout.Constraint(0, 0));
            this.myComponent.setOpaque(false);
            this.myComponent.addMouseMotionListener(this);
            this.myComponent.addMouseListener(this);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.myTooltipComponent.setVisible(false);
            HttpData data = this.findHttpDataUnderCursor(e);
            if (data != null) {
                this.showTooltip(data);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            HttpData data = this.findHttpDataUnderCursor(e);
            if (data != null) {
                this.myStage.setSelectedConnection(data);
                e.consume();
            }
        }

        @Nullable
        private HttpData findHttpDataUnderCursor(@NotNull MouseEvent e) {
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.myTable);
            int row = this.myTable.rowAtPoint(p);
            int column = this.myTable.columnAtPoint(p);
            if (row == -1 || column == -1) {
                return null;
            }
            if (column == 1) {
                Rectangle cellBounds = this.myTable.getCellRect(row, column, false);
                List dataList = (List)this.myTable.getModel().getValueAt(row, 1);
                double at = this.positionToRange(p.x - cellBounds.x, cellBounds.getWidth());
                for (HttpData data : dataList) {
                    if (!((double)data.getStartTimeUs() <= at) || !(at <= (double)data.getEndTimeUs())) continue;
                    return data;
                }
            }
            return null;
        }

        JComponent getComponent() {
            return this.myComponent;
        }

        private void showTooltip(@NotNull HttpData data) {
            this.myTooltipComponent.setVisible(true);
            StringBuilder text = new StringBuilder("<html> <style> p { margin-bottom: 5px; }  p, li { font-size: 11;}</style>");
            text.append("<p style='font-size:12.5'>").append(data.getJavaThreads().get(0).getName()).append("</p>");
            text.append("<p>").append(HttpData.getUrlName(data.getUrl())).append("</p>");
            if (data.getJavaThreads().size() > 1) {
                text.append("<p style='margin-bottom:-5;'>Also accessed by:</p>");
                text.append("<ul>");
                for (int i = 1; i < data.getJavaThreads().size(); ++i) {
                    text.append("<li>").append(data.getJavaThreads().get(i).getName()).append("</li>");
                }
                text.append("</ul>");
            }
            text.append("</html>");
            this.myLabel.setText(text.toString());
        }

        private double positionToRange(double x, double width) {
            Range range = this.myStage.getStudioProfilers().getTimeline().getSelectionRange();
            return x * range.getLength() / width + range.getMin();
        }
    }

    private static final class ConnectionsInfoComponent
    extends JComponent {
        private static final int NAME_PADDING = 6;
        private static final int WARNING_SIZE = 10;
        @NotNull
        private final List<HttpData> myDataList;
        @NotNull
        private final Range myRange;
        @NotNull
        private final JTable myTable;
        @NotNull
        private final NetworkProfilerStage myStage;

        private ConnectionsInfoComponent(@NotNull JTable table, @NotNull List<HttpData> data, @NotNull NetworkProfilerStage stage) {
            this.myStage = stage;
            this.myDataList = data;
            this.myRange = stage.getStudioProfilers().getTimeline().getSelectionRange();
            this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
            this.setForeground(Color.BLACK);
            this.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
            this.myTable = table;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            for (int i = 0; i < this.myDataList.size(); ++i) {
                HttpData data = this.myDataList.get(i);
                double endLimit = i + 1 < this.myDataList.size() ? this.rangeToPosition(this.myDataList.get(i + 1).getStartTimeUs()) : (double)this.getWidth();
                this.drawState(g2d, data, endLimit);
                if (data.getJavaThreads().size() > 1) {
                    this.drawWarning(g2d, data, endLimit);
                }
                this.drawConnectionName(g2d, data, endLimit);
            }
            if (this.myStage.getSelectedConnection() != null && this.myDataList.contains(this.myStage.getSelectedConnection())) {
                this.drawSelection(g2d, this.myStage.getSelectedConnection(), this.getWidth());
            }
            g2d.dispose();
        }

        private void drawState(@NotNull Graphics2D g2d, @NotNull HttpData data, double endLimit) {
            double prev = this.rangeToPosition(data.getStartTimeUs());
            g2d.setColor(ProfilerColors.NETWORK_THREADS_TABLE_SENDING);
            if (data.getDownloadingTimeUs() > 0L) {
                double download = this.rangeToPosition(data.getDownloadingTimeUs());
                g2d.fill(new Rectangle2D.Double(prev, (this.getHeight() - 15) / 2, download - prev, 15.0));
                g2d.setColor(ProfilerColors.NETWORK_THREADS_TABLE_RECEIVING);
                prev = download;
            }
            double end = data.getEndTimeUs() > 0L ? this.rangeToPosition(data.getEndTimeUs()) : endLimit;
            g2d.fill(new Rectangle2D.Double(prev, (this.getHeight() - 15) / 2, end - prev, 15.0));
        }

        private void drawWarning(@NotNull Graphics2D g2d, @NotNull HttpData data, double endLimit) {
            double start = this.rangeToPosition(data.getStartTimeUs());
            double end = data.getEndTimeUs() > 0L ? this.rangeToPosition(data.getEndTimeUs()) : endLimit;
            double stateY = (this.getHeight() - 15) / 2;
            Path2D.Double triangle = new Path2D.Double();
            ((Path2D)triangle).moveTo(end - Math.min(end - start, 10.0), stateY);
            ((Path2D)triangle).lineTo(end, stateY);
            ((Path2D)triangle).lineTo(end, stateY + 10.0);
            triangle.closePath();
            g2d.setColor(this.getBackground());
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.draw(triangle);
            g2d.setColor(ProfilerColors.NETWORK_THREADS_TABLE_WARNING);
            g2d.fill(triangle);
        }

        private void drawConnectionName(@NotNull Graphics2D g2d, @NotNull HttpData data, double endLimit) {
            g2d.setFont(this.getFont());
            g2d.setColor(this.getForeground());
            double start = this.rangeToPosition(data.getStartTimeUs());
            double end = data.getEndTimeUs() > 0L ? this.rangeToPosition(data.getEndTimeUs()) : endLimit;
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            String text = AdtUiUtils.getFittedString((FontMetrics)metrics, (String)HttpData.getUrlName(data.getUrl()), (float)((float)(end - start - 12.0)), (int)1);
            double availableSpace = end - start - (double)metrics.stringWidth(text);
            g2d.drawString(text, (float)(start + availableSpace / 2.0), (float)((double)(this.getHeight() - metrics.getHeight()) * 0.5 + (double)metrics.getAscent()));
        }

        private void drawSelection(@NotNull Graphics2D g2d, @NotNull HttpData data, double endLimit) {
            double start = this.rangeToPosition(data.getStartTimeUs());
            double end = data.getEndTimeUs() > 0L ? this.rangeToPosition(data.getEndTimeUs()) : endLimit;
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setColor(this.myTable.getSelectionBackground());
            Rectangle2D.Double rect = new Rectangle2D.Double(start - 3.0, (this.getHeight() - 15) / 2 - 3, end - start + 6.0, 21.0);
            g2d.draw(rect);
        }

        private double rangeToPosition(double r) {
            return (r - this.myRange.getMin()) / this.myRange.getLength() * (double)this.getWidth();
        }
    }

    private static final class TimelineRenderer
    implements TableCellRenderer,
    TableModelListener {
        @NotNull
        private final JTable myTable;
        @NotNull
        private final List<JComponent> myRows;
        @NotNull
        private final NetworkProfilerStage myStage;

        TimelineRenderer(@NotNull JTable table, @NotNull NetworkProfilerStage stage) {
            this.myTable = table;
            this.myRows = new ArrayList<JComponent>();
            this.myStage = stage;
            this.myTable.getModel().addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.myTable.getModel()));
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.updateRows();
        }

        private void updateRows() {
            this.myRows.clear();
            for (int index = 0; index < this.myTable.getModel().getRowCount(); ++index) {
                List data = (List)this.myTable.getModel().getValueAt(index, 1);
                assert (!data.isEmpty());
                AxisComponent axisTicks = this.createAxis();
                axisTicks.setMarkerLengths(this.myTable.getRowHeight(), 0);
                axisTicks.setShowLabels(false);
                JPanel panel = new JPanel((LayoutManager)new TabularLayout("*", "*"));
                panel.setPreferredSize(new Dimension((int)panel.getPreferredSize().getWidth(), this.myTable.getRowHeight()));
                if (index == 0) {
                    AxisComponent axisLabels = this.createAxis();
                    axisLabels.setMarkerLengths(0, 0);
                    axisLabels.setShowLabels(true);
                    panel.add((Component)axisLabels, new TabularLayout.Constraint(0, 0));
                }
                panel.add((Component)new ConnectionsInfoComponent(this.myTable, data, this.myStage), new TabularLayout.Constraint(0, 0));
                panel.add((Component)axisTicks, new TabularLayout.Constraint(0, 0));
                this.myRows.add(panel);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.myRows.get(row);
        }

        @NotNull
        private AxisComponent createAxis() {
            ProfilerTimeline timeline = this.myStage.getStudioProfilers().getTimeline();
            AxisComponentModel model = new AxisComponentModel(timeline.getSelectionRange(), (BaseAxisFormatter)new TimeAxisFormatter(1, 5, 1));
            model.setClampToMajorTicks(false);
            model.setGlobalRange(timeline.getDataRange());
            AxisComponent axis = new AxisComponent(model, AxisComponent.AxisOrientation.BOTTOM);
            axis.setShowAxisLine(false);
            axis.setMarkerColor(ProfilerColors.NETWORK_TABLE_AXIS);
            model.update(1L);
            return axis;
        }
    }

    private static final class ThreadsTableModel
    extends AbstractTableModel {
        @NotNull
        private final List<List<HttpData>> myThreads = new ArrayList<List<HttpData>>();

        private ThreadsTableModel(@NotNull HttpDataFetcher httpDataFetcher) {
            httpDataFetcher.addListener(this::httpDataChanged);
        }

        private void httpDataChanged(List<HttpData> dataList) {
            this.myThreads.clear();
            if (dataList.isEmpty()) {
                this.fireTableDataChanged();
                return;
            }
            HashMap threads = new HashMap();
            for (HttpData data : dataList) {
                if (data.getJavaThreads().isEmpty()) continue;
                if (!threads.containsKey(data.getJavaThreads().get(0).getId())) {
                    threads.put(data.getJavaThreads().get(0).getId(), new ArrayList());
                }
                ((List)threads.get(data.getJavaThreads().get(0).getId())).add(data);
            }
            threads.values().stream().sorted((o1, o2) -> {
                HttpData.JavaThread thread1 = ((HttpData)o1.get(0)).getJavaThreads().get(0);
                HttpData.JavaThread thread2 = ((HttpData)o2.get(0)).getJavaThreads().get(0);
                int nameCompare = thread1.getName().compareTo(thread2.getName());
                return nameCompare != 0 ? nameCompare : Long.compare(thread1.getId(), thread2.getId());
            }).forEach(this.myThreads::add);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.myThreads.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.myThreads.get(rowIndex).get(0).getJavaThreads().get(0).getName();
            }
            return this.myThreads.get(rowIndex);
        }
    }
}

