/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.stacktrace;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeLocation {
    public static final int INVALID_LINE_NUMBER = -1;
    @NotNull
    private final String myClassName;
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myMethodName;
    @Nullable
    private final String mySignature;
    private final int myLineNumber;
    private final int myHashcode;

    private CodeLocation(@NotNull Builder builder) {
        this.myClassName = builder.myClassName;
        this.myFileName = builder.myFileName;
        this.myMethodName = builder.myMethodName;
        this.mySignature = builder.mySignature;
        this.myLineNumber = builder.myLineNumber;
        this.myHashcode = Arrays.hashCode(new int[]{this.myClassName.hashCode(), this.myFileName == null ? 0 : this.myFileName.hashCode(), this.myMethodName == null ? 0 : this.myMethodName.hashCode(), this.mySignature == null ? 0 : this.mySignature.hashCode(), Integer.hashCode(this.myLineNumber)});
    }

    @NotNull
    public static CodeLocation stub() {
        return new Builder("").build();
    }

    @NotNull
    public String getClassName() {
        return this.myClassName;
    }

    @NotNull
    public String getOuterClassName() {
        int innerCharIndex = this.myClassName.indexOf(36);
        if (innerCharIndex < 0) {
            innerCharIndex = this.myClassName.length();
        }
        return this.myClassName.substring(0, innerCharIndex);
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getMethodName() {
        return this.myMethodName;
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    @Nullable
    public String getSignature() {
        return this.mySignature;
    }

    public int hashCode() {
        return this.myHashcode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CodeLocation)) {
            return false;
        }
        CodeLocation other = (CodeLocation)obj;
        return StringUtil.equals((CharSequence)this.myClassName, (CharSequence)other.myClassName) && StringUtil.equals((CharSequence)this.myFileName, (CharSequence)other.myFileName) && StringUtil.equals((CharSequence)this.myMethodName, (CharSequence)other.myMethodName) && StringUtil.equals((CharSequence)this.mySignature, (CharSequence)other.mySignature) && this.myLineNumber == other.myLineNumber;
    }

    public static final class Builder {
        @NotNull
        private final String myClassName;
        @Nullable
        String myFileName;
        @Nullable
        String myMethodName;
        @Nullable
        String mySignature;
        int myLineNumber = -1;

        public Builder(@NotNull String className) {
            this.myClassName = className;
        }

        public Builder(@NotNull CodeLocation rhs) {
            this.myClassName = rhs.getClassName();
            this.myFileName = rhs.getFileName();
            this.myMethodName = rhs.getMethodName();
            this.mySignature = rhs.getSignature();
            this.myLineNumber = rhs.getLineNumber();
        }

        @NotNull
        public Builder setFileName(@Nullable String fileName) {
            this.myFileName = StringUtil.nullize((String)fileName);
            return this;
        }

        @NotNull
        public Builder setMethodName(@Nullable String methodName) {
            this.myMethodName = StringUtil.nullize((String)methodName);
            return this;
        }

        @NotNull
        public Builder setMethodSignature(@NotNull String methodName, @NotNull String signature) {
            this.myMethodName = methodName;
            this.mySignature = signature;
            return this;
        }

        @NotNull
        public Builder setLineNumber(int lineNumber) {
            this.myLineNumber = lineNumber;
            return this;
        }

        @NotNull
        public CodeLocation build() {
            return new CodeLocation(this);
        }
    }
}

