/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SmartExtensionPoint<Extension, V>
implements ExtensionPointAndAreaListener<Extension> {
    private final Collection<V> myExplicitExtensions;
    private ExtensionPoint<Extension> myExtensionPoint;
    private List<V> myCache;

    protected SmartExtensionPoint(@NotNull Collection<V> explicitExtensions) {
        this.myExplicitExtensions = explicitExtensions;
    }

    @NotNull
    protected abstract ExtensionPoint<Extension> getExtensionPoint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExplicitExtension(@NotNull V extension) {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.add(extension);
            this.myCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExplicitExtension(@NotNull V extension) {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.remove(extension);
            this.myCache = null;
        }
    }

    @Nullable
    protected abstract V getExtension(@NotNull Extension var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<V> getExtensions() {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            if (this.myCache == null) {
                this.myExtensionPoint = this.getExtensionPoint();
                this.myExtensionPoint.addExtensionPointListener(this);
                this.myCache = new ArrayList<V>(this.myExplicitExtensions);
                this.myCache.addAll(ContainerUtil.mapNotNull((Object[])this.myExtensionPoint.getExtensions(), (Function)((NullableFunction)extension -> this.getExtension(extension))));
            }
            return this.myCache;
        }
    }

    @Override
    public final void extensionAdded(@NotNull Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
        this.dropCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropCache() {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            if (this.myCache != null) {
                this.myCache = null;
                this.myExtensionPoint.removeExtensionPointListener(this);
                this.myExtensionPoint = null;
            }
        }
    }

    @Override
    public final void extensionRemoved(@NotNull Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
        this.dropCache();
    }

    @Override
    public void areaReplaced(ExtensionsArea area) {
        this.dropCache();
    }
}

