/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class ExtensionComponentAdapter
implements LoadingOrder.Orderable,
AssignableToComponentAdapter {
    public static final ExtensionComponentAdapter[] EMPTY_ARRAY = new ExtensionComponentAdapter[0];
    private Object myComponentInstance;
    private final Element myExtensionElement;
    private final PicoContainer myContainer;
    private final PluginDescriptor myPluginDescriptor;
    private final boolean myDeserializeInstance;
    private ComponentAdapter myDelegate;
    @NotNull
    private Object myImplementationClassOrName;
    private boolean myNotificationSent;

    public ExtensionComponentAdapter(@NotNull String implementationClassName, Element extensionElement, PicoContainer container, PluginDescriptor pluginDescriptor, boolean deserializeInstance) {
        this.myImplementationClassOrName = implementationClassName;
        this.myExtensionElement = extensionElement;
        this.myContainer = container;
        this.myPluginDescriptor = pluginDescriptor;
        this.myDeserializeInstance = deserializeInstance;
    }

    public Object getComponentKey() {
        return this;
    }

    public Class getComponentImplementation() {
        return this.loadImplementationClass();
    }

    public Object getComponentInstance(PicoContainer container) throws PicoException, ProcessCanceledException {
        if (this.myComponentInstance == null) {
            block9: {
                try {
                    if (Element.class.equals((Object)this.getComponentImplementation())) {
                        this.myComponentInstance = this.myExtensionElement;
                        break block9;
                    }
                    Object componentInstance = this.getDelegate().getComponentInstance(container);
                    if (this.myDeserializeInstance) {
                        try {
                            XmlSerializer.deserializeInto((Object)componentInstance, (Element)this.myExtensionElement);
                        }
                        catch (Exception e) {
                            throw new PicoInitializationException((Throwable)e);
                        }
                    }
                    this.myComponentInstance = componentInstance;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    PluginId pluginId = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginId() : null;
                    throw new PicoPluginExtensionInitializationException(t.getMessage(), t, pluginId);
                }
            }
            if (this.myComponentInstance instanceof PluginAware) {
                PluginAware pluginAware = (PluginAware)this.myComponentInstance;
                pluginAware.setPluginDescriptor(this.myPluginDescriptor);
            }
        }
        return this.myComponentInstance;
    }

    public void verify(PicoContainer container) throws PicoIntrospectionException {
        throw new UnsupportedOperationException("Method verify is not supported in " + this.getClass());
    }

    public void accept(PicoVisitor visitor) {
        throw new UnsupportedOperationException("Method accept is not supported in " + this.getClass());
    }

    public Object getExtension() {
        return this.getComponentInstance(this.myContainer);
    }

    @Override
    public LoadingOrder getOrder() {
        return LoadingOrder.readOrder(this.myExtensionElement.getAttributeValue("order"));
    }

    @Override
    public String getOrderId() {
        return this.myExtensionElement.getAttributeValue("id");
    }

    private Element getExtensionElement() {
        return this.myExtensionElement;
    }

    @Override
    public Element getDescribingElement() {
        return this.getExtensionElement();
    }

    public PluginId getPluginName() {
        return this.myPluginDescriptor.getPluginId();
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @NotNull
    private Class loadImplementationClass() {
        Class<?> implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            try {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = this.myPluginDescriptor == null ? this.getClass().getClassLoader() : this.myPluginDescriptor.getPluginClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                this.myImplementationClassOrName = implementationClassOrName = Class.forName((String)((Object)implementationClassOrName), false, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return implementationClassOrName;
    }

    private synchronized ComponentAdapter getDelegate() {
        if (this.myDelegate == null) {
            Class impl = this.loadImplementationClass();
            this.myDelegate = new CachingConstructorInjectionComponentAdapter(this.getComponentKey(), impl, null, true);
        }
        return this.myDelegate;
    }

    @Override
    public String getAssignableToClassName() {
        Object implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            return (String)implementationClassOrName;
        }
        return ((Class)implementationClassOrName).getName();
    }

    boolean isNotificationSent() {
        return this.myNotificationSent;
    }

    void setNotificationSent(boolean notificationSent) {
        this.myNotificationSent = notificationSent;
    }

    public String toString() {
        return "ExtensionComponentAdapter[" + this.getAssignableToClassName() + "]: plugin=" + this.myPluginDescriptor;
    }
}

