/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.ImmutablePicoContainerProxyFactory;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.VerifyingVisitor;

public class DefaultPicoContainer
implements AreaPicoContainer {
    private final PicoContainer parent;
    private final Set<PicoContainer> children = new THashSet();
    private final Map<Object, ComponentAdapter> componentKeyToAdapterCache = ContainerUtil.newConcurrentMap();
    private final LinkedHashSetWrapper<ComponentAdapter> componentAdapters = new LinkedHashSetWrapper();
    private final Map<String, ComponentAdapter> classNameToAdapter = ContainerUtil.newConcurrentMap();
    private final AtomicReference<FList<ComponentAdapter>> nonAssignableComponentAdapters = new AtomicReference<FList>(FList.emptyList());

    public DefaultPicoContainer(@Nullable PicoContainer parent) {
        this.parent = parent == null ? null : ImmutablePicoContainerProxyFactory.newProxyInstance((PicoContainer)parent);
    }

    public DefaultPicoContainer() {
        this(null);
    }

    public Collection<ComponentAdapter> getComponentAdapters() {
        return this.componentAdapters.getImmutableSet();
    }

    private void appendNonAssignableAdaptersOfType(@NotNull Class componentType, @NotNull List<ComponentAdapter> result) {
        ArrayList<ComponentAdapter> comp = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter componentAdapter : this.nonAssignableComponentAdapters.get()) {
            if (!ReflectionUtil.isAssignable((Class)componentType, (Class)componentAdapter.getComponentImplementation())) continue;
            comp.add(componentAdapter);
        }
        for (int i = comp.size() - 1; i >= 0; --i) {
            result.add((ComponentAdapter)comp.get(i));
        }
    }

    @Nullable
    public final ComponentAdapter getComponentAdapter(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter == null && this.parent != null) {
            return this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    @Nullable
    private ComponentAdapter getFromCache(Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapterCache.get(componentKey);
        if (adapter != null) {
            return adapter;
        }
        if (componentKey instanceof Class) {
            return this.componentKeyToAdapterCache.get(((Class)componentKey).getName());
        }
        return null;
    }

    @Nullable
    public ComponentAdapter getComponentAdapterOfType(@NotNull Class componentType) {
        ComponentAdapter adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        List<ComponentAdapter> found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return found.get(0);
        }
        if (found.isEmpty()) {
            return this.parent == null ? null : this.parent.getComponentAdapterOfType(componentType);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public List<ComponentAdapter> getComponentAdaptersOfType(Class componentType) {
        if (componentType == null || componentType == String.class) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        ComponentAdapter cacheHit = this.classNameToAdapter.get(componentType.getName());
        if (cacheHit != null) {
            result.add(cacheHit);
        }
        this.appendNonAssignableAdaptersOfType(componentType, (List<ComponentAdapter>)result);
        return result;
    }

    public ComponentAdapter registerComponent(@NotNull ComponentAdapter componentAdapter) {
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.containsKey(componentKey)) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        if (componentAdapter instanceof AssignableToComponentAdapter) {
            String classKey = ((AssignableToComponentAdapter)componentAdapter).getAssignableToClassName();
            this.classNameToAdapter.put(classKey, componentAdapter);
        } else {
            FList newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), (FList<ComponentAdapter>)(newList = oldList.prepend((Object)componentAdapter)))) {
            }
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter unregisterComponent(@NotNull Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        if (adapter instanceof AssignableToComponentAdapter) {
            this.classNameToAdapter.remove(((AssignableToComponentAdapter)adapter).getAssignableToClassName());
        } else {
            FList newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), (FList<ComponentAdapter>)(newList = oldList.without((Object)adapter)))) {
            }
        }
        return adapter;
    }

    public List getComponentInstances() {
        return this.getComponentInstancesOfType(Object.class);
    }

    public List<Object> getComponentInstancesOfType(@Nullable Class componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (ComponentAdapter componentAdapter : this.getComponentAdapters()) {
            if (!ReflectionUtil.isAssignable((Class)componentType, (Class)componentAdapter.getComponentImplementation())) continue;
            ContainerUtil.addIfNotNull(result, (Object)this.getInstance(componentAdapter));
        }
        return result;
    }

    @Nullable
    public Object getComponentInstance(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter != null) {
            return this.getLocalInstance(adapter);
        }
        if (this.parent != null && (adapter = this.parent.getComponentAdapter(componentKey)) != null) {
            return this.parent.getComponentInstance(adapter.getComponentKey());
        }
        return null;
    }

    @Nullable
    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    @Nullable
    private Object getInstance(@NotNull ComponentAdapter componentAdapter) {
        if (this.getComponentAdapters().contains(componentAdapter)) {
            return this.getLocalInstance(componentAdapter);
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    private Object getLocalInstance(@NotNull ComponentAdapter componentAdapter) {
        Object instance;
        Throwable firstLevelException;
        try {
            return componentAdapter.getComponentInstance((PicoContainer)this);
        }
        catch (PicoInitializationException e) {
            firstLevelException = e;
        }
        catch (PicoIntrospectionException e) {
            firstLevelException = e;
        }
        if (this.parent != null && (instance = this.parent.getComponentInstance(componentAdapter.getComponentKey())) != null) {
            return instance;
        }
        throw firstLevelException;
    }

    @Nullable
    public ComponentAdapter unregisterComponentByInstance(@NotNull Object componentInstance) {
        for (ComponentAdapter adapter : this.getComponentAdapters()) {
            Object o = this.getInstance(adapter);
            if (o == null || !o.equals(componentInstance)) continue;
            return this.unregisterComponent(adapter.getComponentKey());
        }
        return null;
    }

    public void verify() {
        new VerifyingVisitor().traverse((Object)this);
    }

    public void start() {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer pc = new DefaultPicoContainer((PicoContainer)this);
        this.addChildContainer((PicoContainer)pc);
        return pc;
    }

    public boolean addChildContainer(@NotNull PicoContainer child) {
        return this.children.add(child);
    }

    public boolean removeChildContainer(@NotNull PicoContainer child) {
        return this.children.remove(child);
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitContainer((PicoContainer)this);
        for (ComponentAdapter adapter : this.getComponentAdapters()) {
            adapter.accept(visitor);
        }
        for (PicoContainer child : new SmartList(this.children)) {
            child.accept(visitor);
        }
    }

    public ComponentAdapter registerComponentInstance(@NotNull Object component) {
        return this.registerComponentInstance(component.getClass(), component);
    }

    public ComponentAdapter registerComponentInstance(@NotNull Object componentKey, @NotNull Object componentInstance) {
        return this.registerComponent((ComponentAdapter)new InstanceComponentAdapter(componentKey, componentInstance));
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Class componentImplementation) {
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation) {
        return this.registerComponentImplementation(componentKey, componentImplementation, null);
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters) {
        CachingConstructorInjectionComponentAdapter componentAdapter = new CachingConstructorInjectionComponentAdapter(componentKey, componentImplementation, parameters, true);
        return this.registerComponent((ComponentAdapter)componentAdapter);
    }

    public PicoContainer getParent() {
        return this.parent;
    }

    public String toString() {
        return "DefaultPicoContainer" + (this.getParent() == null ? " (root)" : " (parent=" + this.getParent() + ")");
    }

    private static class LinkedHashSetWrapper<T> {
        private final Object lock = new Object();
        private volatile Set<T> immutableSet;
        private LinkedHashSet<T> synchronizedSet = new LinkedHashSet();

        private LinkedHashSetWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull T element) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.synchronizedSet.contains(element)) {
                    this.copySyncSetIfExposedAsImmutable().add(element);
                }
            }
        }

        private LinkedHashSet<T> copySyncSetIfExposedAsImmutable() {
            if (this.immutableSet != null) {
                this.immutableSet = null;
                this.synchronizedSet = new LinkedHashSet<T>(this.synchronizedSet);
            }
            return this.synchronizedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@Nullable T element) {
            Object object = this.lock;
            synchronized (object) {
                this.copySyncSetIfExposedAsImmutable().remove(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<T> getImmutableSet() {
            Set<T> res = this.immutableSet;
            if (res == null) {
                Object object = this.lock;
                synchronized (object) {
                    res = this.immutableSet;
                    if (res == null) {
                        this.immutableSet = res = Collections.unmodifiableSet(this.synchronizedSet);
                    }
                }
            }
            return res;
        }
    }
}

