/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetector;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.NullableFunction;
import com.intellij.util.StringBuilderSpinAllocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;

public class GroovySourceRootDetector
extends JavaSourceRootDetector {
    @NotNull
    protected String getLanguageName() {
        return "Groovy";
    }

    @NotNull
    protected String getFileExtension() {
        return "groovy";
    }

    @NotNull
    protected NullableFunction<CharSequence, String> getPackageNameFetcher() {
        return charSequence -> GroovySourceRootDetector.getPackageName(charSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getPackageName(CharSequence text) {
        GroovyLexer lexer = new GroovyLexer();
        lexer.start(text);
        GroovySourceRootDetector.skipWhitespacesAndComments((Lexer)lexer);
        IElementType firstToken = lexer.getTokenType();
        if (firstToken != GroovyTokenTypes.kPACKAGE) {
            return "";
        }
        lexer.advance();
        GroovySourceRootDetector.skipWhitespacesAndComments((Lexer)lexer);
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            while (lexer.getTokenType() == GroovyTokenTypes.mIDENT) {
                buffer.append(text, lexer.getTokenStart(), lexer.getTokenEnd());
                lexer.advance();
                GroovySourceRootDetector.skipWhitespacesAndComments((Lexer)lexer);
                if (lexer.getTokenType() != GroovyTokenTypes.mDOT) break;
                buffer.append('.');
                lexer.advance();
                GroovySourceRootDetector.skipWhitespacesAndComments((Lexer)lexer);
            }
            String packageName = buffer.toString();
            if (packageName.isEmpty() || StringUtil.endsWithChar((CharSequence)packageName, (char)'.')) {
                String string = null;
                return string;
            }
            String string = packageName;
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    private static void skipWhitespacesAndComments(Lexer lexer) {
        while (TokenSets.ALL_COMMENT_TOKENS.contains(lexer.getTokenType()) || TokenSets.WHITE_SPACES_SET.contains(lexer.getTokenType())) {
            lexer.advance();
        }
    }
}

