/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions.generate.constructors;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateConstructorHandler;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.actions.generate.GroovyGenerationInfo;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GroovyToJavaGenerator;

public class GroovyGenerateConstructorHandler
extends GenerateConstructorHandler {
    private static final Logger LOG = Logger.getInstance(GroovyGenerateConstructorHandler.class);
    private static final String DEF_PSEUDO_ANNO = "_____intellij_idea_rulez_def_";

    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        ClassMember[] classMembers = this.chooseOriginalMembersImpl(aClass, project);
        if (classMembers == null) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        for (ClassMember classMember : classMembers) {
            if (classMember instanceof PsiMethodMember) {
                PsiMethod method = (PsiMethod)((PsiMethodMember)classMember).getElement();
                PsiMethod copy = factory.createMethodFromText(GroovyToJavaGenerator.generateMethodStub(method), (PsiElement)method);
                if (method instanceof GrMethod) {
                    GrParameter[] parameters = ((GrMethod)method).getParameterList().getParameters();
                    PsiParameter[] copyParameters = copy.getParameterList().getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        if (parameters[i].getTypeElementGroovy() != null) continue;
                        copyParameters[i].setName(DEF_PSEUDO_ANNO + parameters[i].getName());
                    }
                }
                res.add(new PsiMethodMember(copy));
                continue;
            }
            if (!(classMember instanceof PsiFieldMember)) continue;
            PsiField field = (PsiField)((PsiFieldMember)classMember).getElement();
            String prefix = field instanceof GrField && ((GrField)field).getTypeElementGroovy() == null ? DEF_PSEUDO_ANNO : "";
            res.add(new PsiFieldMember(factory.createFieldFromText(field.getType().getCanonicalText() + " " + prefix + field.getName(), (PsiElement)aClass)));
        }
        return res.toArray(new ClassMember[res.size()]);
    }

    @Nullable
    protected ClassMember[] chooseOriginalMembersImpl(PsiClass aClass, Project project) {
        return super.chooseOriginalMembers(aClass, project);
    }

    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        List list = super.generateMemberPrototypes(aClass, members);
        ArrayList<GroovyGenerationInfo<GrMethod>> grConstructors = new ArrayList<GroovyGenerationInfo<GrMethod>>();
        Project project = aClass.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        for (GenerationInfo generationInfo : list) {
            PsiMember constructorMember = generationInfo.getPsiMember();
            assert (constructorMember instanceof PsiMethod);
            PsiMethod constructor = (PsiMethod)constructorMember;
            PsiCodeBlock block = constructor.getBody();
            assert (block != null);
            String constructorName = aClass.getName();
            String body = StringUtil.replace((String)StringUtil.replace((String)block.getText(), (String)DEF_PSEUDO_ANNO, (String)""), (String)";", (String)"");
            PsiParameterList list1 = constructor.getParameterList();
            ArrayList<String> parametersNames = new ArrayList<String>();
            ArrayList<String> parametersTypes = new ArrayList<String>();
            for (PsiParameter parameter : list1.getParameters()) {
                String fullName = parameter.getName();
                parametersNames.add(StringUtil.trimStart((String)fullName, (String)DEF_PSEUDO_ANNO));
                parametersTypes.add(fullName.startsWith(DEF_PSEUDO_ANNO) ? null : parameter.getType().getCanonicalText());
            }
            String[] paramNames = ArrayUtil.toStringArray(parametersNames);
            String[] paramTypes = ArrayUtil.toStringArray(parametersTypes);
            assert (constructorName != null);
            GrMethod grConstructor = factory.createConstructorFromText(constructorName, paramTypes, paramNames, body);
            PsiReferenceList throwsList = grConstructor.getThrowsList();
            for (PsiJavaCodeReferenceElement element : constructor.getThrowsList().getReferenceElements()) {
                throwsList.add((PsiElement)element);
            }
            codeStyleManager.shortenClassReferences((PsiElement)grConstructor);
            grConstructors.add(new GroovyGenerationInfo<GrMethod>(grConstructor));
        }
        return grConstructors;
    }
}

