/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions.generate.missing;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.actions.generate.GroovyCodeInsightBundle;
import org.jetbrains.plugins.groovy.actions.generate.GroovyGenerationInfo;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyGenerateMethodMissingHandler
extends GenerateMembersHandlerBase {
    private static final Logger LOG = Logger.getInstance(GroovyGenerateMethodMissingHandler.class);

    public GroovyGenerateMethodMissingHandler() {
        super("");
    }

    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        return ClassMember.EMPTY_ARRAY;
    }

    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        String templName = "New Method Body.java";
        FileTemplate template = FileTemplateManager.getInstance((Project)aClass.getProject()).getCodeTemplate("New Method Body.java");
        GrMethod method = GroovyGenerateMethodMissingHandler.genMethod(aClass, template);
        return method != null ? Collections.singletonList(new GroovyGenerationInfo<GrMethod>(method, true)) : Collections.emptyList();
    }

    @Nullable
    private static GrMethod genMethod(PsiClass aClass, FileTemplate template) {
        String bodyText;
        String className;
        Properties properties = FileTemplateManager.getInstance((Project)aClass.getProject()).getDefaultProperties();
        properties.setProperty("RETURN_TYPE", "java.lang.Object");
        properties.setProperty("DEFAULT_RETURN_VALUE", "null");
        properties.setProperty("CALL_SUPER", "");
        String fqn = aClass.getQualifiedName();
        if (fqn != null) {
            properties.setProperty("CLASS_NAME", fqn);
        }
        if ((className = aClass.getName()) != null) {
            properties.setProperty("SIMPLE_CLASS_NAME", className);
        }
        properties.setProperty("METHOD_NAME", "methodMissing");
        try {
            bodyText = StringUtil.replace((String)template.getText(properties), (String)";", (String)"");
        }
        catch (IOException e) {
            return null;
        }
        return GroovyPsiElementFactory.getInstance(aClass.getProject()).createMethodFromText("def methodMissing(String name, def args) {\n" + bodyText + "\n}");
    }

    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) throws IncorrectOperationException {
        return GenerationInfo.EMPTY_ARRAY;
    }

    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        PsiMethod[] missings = aClass.findMethodsByName("methodMissing", true);
        PsiMethod method = null;
        for (PsiMethod missing : missings) {
            PsiParameter[] parameters = missing.getParameterList().getParameters();
            if (parameters.length != 2 || !GroovyGenerateMethodMissingHandler.isNameParam(parameters[0])) continue;
            method = missing;
        }
        if (method != null) {
            String text = GroovyCodeInsightBundle.message("generate.method.missing.already.defined.warning", new Object[0]);
            if (Messages.showYesNoDialog((Project)project, (String)text, (String)GroovyCodeInsightBundle.message("generate.method.missing.already.defined.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                final PsiMethod finalMethod = method;
                if (!((Boolean)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        try {
                            finalMethod.delete();
                            return Boolean.TRUE;
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                            return Boolean.FALSE;
                        }
                    }
                })).booleanValue()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return new ClassMember[1];
    }

    private static boolean isNameParam(PsiParameter parameter) {
        return parameter.getType().equalsToText("java.lang.String") || parameter.getType().equalsToText("java.lang.Object");
    }

    @Nullable
    protected ClassMember[] chooseMembers(ClassMember[] members, boolean allowEmptySelection, boolean copyJavadocCheckbox, Project project, @Nullable Editor editor) {
        return ClassMember.EMPTY_ARRAY;
    }
}

