/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.GrUnresolvedAccessChecker;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

class ResolveHighlightingVisitor
extends GroovyRecursiveElementVisitor {
    private final GrUnresolvedAccessChecker myReferenceChecker;
    private final List<HighlightInfo> myInfos;

    public ResolveHighlightingVisitor(@NotNull GroovyFileBase file, @NotNull Project project, @NotNull List<HighlightInfo> collector) {
        this.myReferenceChecker = new GrUnresolvedAccessChecker(file, project);
        this.myInfos = collector;
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        List<HighlightInfo> infos;
        int size = this.myInfos.size();
        super.visitReferenceExpression(referenceExpression);
        if (size == this.myInfos.size() && (infos = this.myReferenceChecker.checkReferenceExpression(referenceExpression)) != null) {
            ContainerUtil.addAllNotNull(this.myInfos, infos);
        }
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        HighlightInfo info;
        int size = this.myInfos.size();
        super.visitCodeReferenceElement(refElement);
        if (size == this.myInfos.size() && (info = this.myReferenceChecker.checkCodeReferenceElement(refElement)) != null) {
            this.myInfos.add(info);
        }
    }
}

