/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

class AliasedAnnotationHolder
implements AnnotationHolder {
    private final AnnotationHolder myHolder;
    private final GrAnnotation myAlias;
    private final GrCodeReferenceElement myReference;

    public AliasedAnnotationHolder(@NotNull AnnotationHolder holder, @NotNull GrAnnotation alias) {
        this.myHolder = holder;
        this.myAlias = alias;
        this.myReference = this.myAlias.getClassReference();
    }

    @NotNull
    private PsiElement findCodeElement(@NotNull PsiElement elt) {
        if (PsiTreeUtil.isAncestor((PsiElement)this.myAlias, (PsiElement)elt, (boolean)true)) {
            return elt;
        }
        return this.myReference;
    }

    public Annotation createErrorAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        PsiElement codeElement = this.findCodeElement(elt);
        return this.myHolder.createErrorAnnotation(codeElement, message);
    }

    public Annotation createErrorAnnotation(@NotNull ASTNode node, @Nullable String message) {
        return this.createErrorAnnotation(node.getPsi(), message);
    }

    public Annotation createErrorAnnotation(@NotNull TextRange range, @Nullable String message) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createWarningAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        return this.myHolder.createWarningAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createWarningAnnotation(@NotNull ASTNode node, @Nullable String message) {
        return this.myHolder.createWarningAnnotation(node.getPsi(), message);
    }

    public Annotation createWarningAnnotation(@NotNull TextRange range, @Nullable String message) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createWeakWarningAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        return this.myHolder.createWeakWarningAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull ASTNode node, @Nullable String message) {
        return this.myHolder.createWarningAnnotation(node.getPsi(), message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull TextRange range, @Nullable String message) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createInfoAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        return this.myHolder.createInfoAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createInfoAnnotation(@NotNull ASTNode node, @Nullable String message) {
        return this.myHolder.createInfoAnnotation(node.getPsi(), message);
    }

    public Annotation createInfoAnnotation(@NotNull TextRange range, @Nullable String message) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message, @Nullable String htmlTooltip) {
        throw new UnsupportedOperationException("unsupported");
    }

    @NotNull
    public AnnotationSession getCurrentAnnotationSession() {
        return this.myHolder.getCurrentAnnotationSession();
    }

    public boolean isBatchMode() {
        return this.myHolder.isBatchMode();
    }
}

