/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

public class CreateFieldFromConstructorLabelFix
extends GroovyFix {
    private final CreateFieldFix myFix;
    private final GrNamedArgument myNamedArgument;

    public CreateFieldFromConstructorLabelFix(GrTypeDefinition targetClass, GrNamedArgument namedArgument) {
        this.myFix = new CreateFieldFix(targetClass);
        this.myNamedArgument = namedArgument;
    }

    @Nullable
    private String getFieldName() {
        GrArgumentLabel label = this.myNamedArgument.getLabel();
        assert (label != null);
        return label.getName();
    }

    private TypeConstraint[] calculateTypeConstrains() {
        GrExpression expression = this.myNamedArgument.getExpression();
        PsiType type = null;
        if (expression != null) {
            type = expression.getType();
        }
        if (type != null) {
            return new TypeConstraint[]{SupertypeConstraint.create(type, type)};
        }
        return TypeConstraint.EMPTY_ARRAY;
    }

    @NotNull
    public String getName() {
        return GroovyBundle.message("create.field.from.usage", this.getFieldName());
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Create field";
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        this.myFix.doFix(project, ArrayUtil.EMPTY_STRING_ARRAY, this.getFieldName(), this.calculateTypeConstrains(), this.myNamedArgument);
    }
}

