/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrMoveClassToCorrectPlaceFix
extends Intention {
    private static final Logger LOG = Logger.getInstance(GrMoveClassToCorrectPlaceFix.class);
    private final GrTypeDefinition myClass;

    public GrMoveClassToCorrectPlaceFix(GrTypeDefinition clazz) {
        this.myClass = clazz;
        LOG.assertTrue(!this.myClass.isAnonymous());
    }

    @Override
    @NotNull
    public String getText() {
        return GroovyBundle.message("move.class.0.from.method", this.myClass.getName());
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("move.class.from.method.family.name", new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myClass.isValid();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrTypeDefinition containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myClass, GrTypeDefinition.class);
        if (containingClass != null) {
            containingClass.add(this.myClass);
        } else {
            PsiFile containingFile = this.myClass.getContainingFile();
            PsiElement added = containingFile.add((PsiElement)this.myClass);
            PsiElement prevSibling = added.getPrevSibling();
            if (prevSibling != null && prevSibling.getNode().getElementType() != GroovyTokenTypes.mNLS) {
                containingFile.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", added.getNode());
            }
        }
        this.myClass.delete();
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                return GrMoveClassToCorrectPlaceFix.this.myClass.isValid();
            }
        };
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

