/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.tree.TreeUtil;
import icons.JetgroovyIcons;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicToolWindowWrapper;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DClassElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DPropertyElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrDynamicImplicitElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrImplicitVariableImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrDynamicImplicitProperty
extends GrImplicitVariableImpl
implements GrDynamicImplicitElement,
PsiField {
    private final String myContainingClassName;
    private final Project myProject;

    public GrDynamicImplicitProperty(PsiManager manager, @NonNls String name, @NonNls @NotNull String type, String containingClassName) {
        super(manager, name, type, null);
        this.myContainingClassName = containingClassName;
        this.myProject = manager.getProject();
        this.setOriginInfo("dynamic property");
    }

    @Override
    @Nullable
    public PsiClass getContainingClassElement() {
        PsiClassType containingClassType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeByFQClassName(this.myContainingClassName, ProjectScope.getAllScope((Project)this.getProject()));
        return containingClassType.resolve();
    }

    @Override
    public String getContainingClassName() {
        return this.myContainingClassName;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiClass psiClass = this.getContainingClassElement();
        if (psiClass == null) {
            return null;
        }
        return psiClass.getContainingFile();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        DynamicManager.getInstance(this.getProject()).replaceDynamicPropertyName(this.myContainingClassName, this.getName(), name);
        return super.setName(name);
    }

    public String getPresentableText() {
        return this.getName();
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        return GlobalSearchScope.projectScope((Project)this.myProject);
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigateToSource()) {
            super.navigate(requestFocus);
            return;
        }
        DynamicToolWindowWrapper.getInstance(this.myProject).getToolWindow().activate(() -> {
            DynamicToolWindowWrapper toolWindowWrapper = DynamicToolWindowWrapper.getInstance(this.myProject);
            TreeTable treeTable = toolWindowWrapper.getTreeTable();
            ListTreeTableModelOnColumns model = toolWindowWrapper.getTreeTableModel();
            Object root = model.getRoot();
            if (root == null || !(root instanceof DefaultMutableTreeNode)) {
                return;
            }
            DefaultMutableTreeNode treeRoot = (DefaultMutableTreeNode)root;
            PsiClass psiClass = this.getContainingClassElement();
            if (psiClass == null) {
                return;
            }
            DPropertyElement dynamicProperty = null;
            PsiClass trueSuper = null;
            for (PsiClass aSuper : PsiUtil.iterateSupers(psiClass, true)) {
                dynamicProperty = DynamicManager.getInstance(this.myProject).findConcreteDynamicProperty(aSuper.getQualifiedName(), this.getName());
                if (dynamicProperty == null) continue;
                trueSuper = aSuper;
                break;
            }
            if (trueSuper == null) {
                return;
            }
            DefaultMutableTreeNode classNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)treeRoot, (Object)new DClassElement(this.myProject, trueSuper.getQualifiedName()));
            if (classNode == null) {
                return;
            }
            DefaultMutableTreeNode desiredNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)classNode, (Object)dynamicProperty);
            if (desiredNode == null) {
                return;
            }
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)desiredNode);
            treeTable.getTree().expandPath(path);
            treeTable.getTree().setSelectionPath(path);
            treeTable.getTree().fireTreeExpanded(path);
            ToolWindowManager.getInstance((Project)this.myProject).getFocusManager().requestFocus((Component)treeTable, true);
            treeTable.revalidate();
            treeTable.repaint();
        }, true);
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return JetgroovyIcons.Groovy.Property;
    }

    public boolean isValid() {
        return true;
    }

    public PsiClass getContainingClass() {
        return this.getContainingClassElement();
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public void setInitializer(@Nullable PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @NotNull
    public PsiType getType() {
        PsiType type = super.getType();
        if (type instanceof PsiClassType && ((PsiClassType)type).resolve() == null) {
            return TypesUtil.getJavaLangObject((PsiElement)this);
        }
        return type;
    }
}

