/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.builder;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiType;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.builder.BuilderMethodsContributor;
import org.jetbrains.plugins.groovy.builder.UtilsKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

public class JsonDelegateContributor
extends BuilderMethodsContributor {
    static final String DELEGATE_FQN = "groovy.json.JsonDelegate";

    @Override
    @Nullable
    protected String getParentClassName() {
        return DELEGATE_FQN;
    }

    @Override
    boolean processDynamicMethods(@NotNull PsiType qualifierType, @NotNull PsiClass clazz, @NotNull String name, @NotNull PsiElement place, @NotNull Processor<PsiElement> processor) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)place.getProject());
        GrLightMethodBuilder method = JsonDelegateContributor.createMethod(name, clazz, place);
        PsiClassType genericType = facade.getElementFactory().createType((PsiClass)method.addTypeParameter("T"));
        method.addParameter("value", (PsiType)genericType, false);
        method.setReturnType((PsiType)genericType);
        if (!processor.process((Object)method)) {
            return false;
        }
        method = JsonDelegateContributor.createMethod(name, clazz, place);
        genericType = facade.getElementFactory().createType((PsiClass)method.addTypeParameter("T"));
        method.addParameter("values", (PsiType)genericType.createArrayType(), false);
        method.addAndGetParameter("c", "groovy.lang.Closure", false).putUserData(GrDelegatesToUtilKt.DELEGATES_TO_KEY, DELEGATE_FQN);
        method.setReturnType((PsiType)TypesUtil.createListType(place, (PsiType)genericType));
        if (!processor.process((Object)method)) {
            return false;
        }
        method = JsonDelegateContributor.createMethod(name, clazz, place);
        genericType = facade.getElementFactory().createType((PsiClass)method.addTypeParameter("T"));
        method.addParameter("values", (PsiType)TypesUtil.createIterableType(place, (PsiType)genericType), false);
        method.addAndGetParameter("c", "groovy.lang.Closure", false).putUserData(GrDelegatesToUtilKt.DELEGATES_TO_KEY, DELEGATE_FQN);
        method.setReturnType((PsiType)TypesUtil.createListType(place, (PsiType)genericType));
        if (!processor.process((Object)method)) {
            return false;
        }
        method = JsonDelegateContributor.createMethod(name, clazz, place);
        genericType = facade.getElementFactory().createType((PsiClass)method.addTypeParameter("T"));
        method.addAndGetParameter("values", (PsiType)new PsiEllipsisType((PsiType)genericType), false);
        method.setReturnType((PsiType)TypesUtil.createListType(place, (PsiType)genericType));
        return processor.process((Object)method);
    }

    private static GrLightMethodBuilder createMethod(@NotNull String name, @NotNull PsiClass clazz, @NotNull PsiElement context) {
        GrLightMethodBuilder method = new GrLightMethodBuilder(context.getManager(), name);
        method.setOriginInfo("via JsonBuilder");
        method.addModifier("public");
        UtilsKt.setContainingClass(method, clazz);
        return method;
    }
}

