/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public abstract class CallInfoBase<T extends GrCall>
implements CallInfo<T> {
    private final T myCall;
    private final NullableLazyValue<PsiType[]> myArgTypes = new NullableLazyValue<PsiType[]>(){

        @Nullable
        protected PsiType[] compute() {
            return CallInfoBase.this.inferArgTypes();
        }
    };

    protected CallInfoBase(T call) {
        this.myCall = call;
    }

    @Nullable
    protected abstract PsiType[] inferArgTypes();

    @Override
    @Nullable
    public GrArgumentList getArgumentList() {
        return this.myCall.getArgumentList();
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        return (PsiType[])this.myArgTypes.getValue();
    }

    @Override
    @NotNull
    public GroovyResolveResult advancedResolve() {
        return this.myCall.advancedResolve();
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve() {
        return this.myCall.multiResolve(false);
    }

    @Override
    @NotNull
    public T getCall() {
        return this.myCall;
    }

    @Override
    @NotNull
    public GrExpression[] getExpressionArguments() {
        return this.myCall.getExpressionArguments();
    }

    @Override
    @NotNull
    public GrClosableBlock[] getClosureArguments() {
        return this.myCall.getClosureArguments();
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        return this.myCall.getNamedArguments();
    }
}

