/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GroovyAssignmentToMethodParameterInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Assignment issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Assignment to method parameter";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Assignment to method parameter '#ref' #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression expr) {
            super.visitAssignmentExpression(expr);
            this.check(expr.getLValue());
        }

        private void check(@Nullable GrExpression lhs) {
            if (!(lhs instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)lhs).resolve();
            if (referent == null) {
                return;
            }
            if (!(referent instanceof GrParameter)) {
                return;
            }
            if (referent.getParent() instanceof GrForClause) {
                return;
            }
            this.registerError(lhs);
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            super.visitUnaryExpression(expression);
            IElementType op = expression.getOperationTokenType();
            if (op == GroovyTokenTypes.mINC || op == GroovyTokenTypes.mDEC) {
                this.check(expression.getOperand());
            }
        }
    }
}

