/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrEqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        return GroovyInspectionBundle.message("equals.between.inconvertible.types.tooltip", args[0], args[1], args[2]);
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression.getOperationTokenType() != GroovyTokenTypes.mEQUAL) {
                return;
            }
            PsiType leftType = expression.getLeftType();
            if (leftType == null) {
                return;
            }
            PsiType rightType = expression.getRightType();
            if (rightType == null) {
                return;
            }
            if (TypeUtils.areConvertible((PsiType)rightType, (PsiType)leftType)) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)leftType, (String)"java.lang.Number")) {
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.Number")) {
                    return;
                }
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.Character")) {
                    return;
                }
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.String")) {
                    return;
                }
            } else if (InheritanceUtil.isInheritor((PsiType)leftType, (String)"java.lang.Character")) {
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.Number")) {
                    return;
                }
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.String")) {
                    return;
                }
            } else if (InheritanceUtil.isInheritor((PsiType)leftType, (String)"java.lang.String")) {
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.Number")) {
                    return;
                }
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.Character")) {
                    return;
                }
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"groovy.lang.GString")) {
                    return;
                }
            } else if (InheritanceUtil.isInheritor((PsiType)leftType, (String)"groovy.lang.GString") && InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.String")) {
                return;
            }
            this.registerError(expression.getOperationToken(), "==", leftType.getPresentableText(), rightType.getPresentableText());
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
            this.processMethodCall(methodCallExpression);
        }

        @Override
        public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
            this.processMethodCall(applicationStatement);
        }

        private void processMethodCall(GrMethodCall methodCall) {
            GrExpression invokedExpression = methodCall.getInvokedExpression();
            if (!(invokedExpression instanceof GrReferenceExpression)) {
                return;
            }
            String name = ((GrReferenceExpression)invokedExpression).getReferenceName();
            if (!"equals".equals(name)) {
                return;
            }
            PsiType leftType = PsiImplUtil.getQualifierType((GrReferenceExpression)invokedExpression);
            if (leftType == null) {
                return;
            }
            PsiType[] argumentTypes = PsiUtil.getArgumentTypes(methodCall.getArgumentList());
            if (argumentTypes == null || argumentTypes.length != 1) {
                return;
            }
            PsiType rightType = argumentTypes[0];
            if (rightType == null) {
                return;
            }
            PsiMethod method = methodCall.resolveMethod();
            if (!MethodUtils.isEquals((PsiMethod)method)) {
                return;
            }
            if (method.hasModifierProperty("static")) {
                return;
            }
            if (TypeUtils.areConvertible((PsiType)rightType, (PsiType)leftType)) {
                return;
            }
            this.registerMethodCallError(methodCall, "equals()", leftType.getPresentableText(), rightType.getPresentableText());
        }
    }
}

