/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyNonShortCircuitBooleanInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Non short-circuit boolean";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Non short-circuit boolean expression #loc";
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        return new NonShortCircuitBooleanFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            GrExpression rhs = expression.getRightOperand();
            if (rhs == null) {
                return;
            }
            IElementType sign = expression.getOperationTokenType();
            if (!GroovyTokenTypes.mBAND.equals(sign) && !GroovyTokenTypes.mBOR.equals(sign)) {
                return;
            }
            if (!PsiType.BOOLEAN.equals((Object)rhs.getType())) {
                return;
            }
            this.registerError(expression);
        }
    }

    private static class NonShortCircuitBooleanFix
    extends GroovyFix {
        private NonShortCircuitBooleanFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Replace with short-circuit expression";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            GrBinaryExpression expression = (GrBinaryExpression)descriptor2.getPsiElement();
            GrExpression lhs = expression.getLeftOperand();
            GrExpression rhs = expression.getRightOperand();
            IElementType operationSign = expression.getOperationTokenType();
            assert (rhs != null);
            String newExpression = lhs.getText() + NonShortCircuitBooleanFix.getShortCircuitOperand(operationSign) + rhs.getText();
            NonShortCircuitBooleanFix.replaceExpression(expression, newExpression);
        }

        private static String getShortCircuitOperand(IElementType tokenType) {
            if (tokenType.equals(GroovyTokenTypes.mBAND)) {
                return "&&";
            }
            return "||";
        }
    }
}

