/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.arithmetic.GrRangeExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrRangeType;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyRangeTypeCheckInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return GroovyInspectionBundle.message("incorrect.range.argument", new Object[0]);
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        GrRangeExpression range = (GrRangeExpression)location;
        PsiType type = range.getType();
        final ArrayList<GroovyFix> fixes = new ArrayList<GroovyFix>(3);
        if (type instanceof GrRangeType) {
            PsiType iterationType = ((GrRangeType)type).getIterationType();
            if (!(iterationType instanceof PsiClassType)) {
                return null;
            }
            final PsiClass psiClass = ((PsiClassType)iterationType).resolve();
            if (!(psiClass instanceof GrTypeDefinition)) {
                return null;
            }
            GroovyResolveResult[] nexts = ResolveUtil.getMethodCandidates(iterationType, "next", (PsiElement)range, new PsiType[0]);
            GroovyResolveResult[] previouses = ResolveUtil.getMethodCandidates(iterationType, "previous", (PsiElement)range, new PsiType[0]);
            GroovyResolveResult[] compareTos = ResolveUtil.getMethodCandidates(iterationType, "compareTo", (PsiElement)range, iterationType);
            if (GroovyRangeTypeCheckInspection.countImplementations(psiClass, nexts) == 0) {
                fixes.add(GroovyQuickFixFactory.getInstance().createAddMethodFix("next", (GrTypeDefinition)psiClass));
            }
            if (GroovyRangeTypeCheckInspection.countImplementations(psiClass, previouses) == 0) {
                fixes.add(GroovyQuickFixFactory.getInstance().createAddMethodFix("previous", (GrTypeDefinition)psiClass));
            }
            if (!InheritanceUtil.isInheritor((PsiType)iterationType, (String)"java.lang.Comparable") || GroovyRangeTypeCheckInspection.countImplementations(psiClass, compareTos) == 0) {
                fixes.add(GroovyQuickFixFactory.getInstance().createAddClassToExtendsFix((GrTypeDefinition)psiClass, "java.lang.Comparable"));
            }
            return new GroovyFix(){

                @Override
                protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
                    for (GroovyFix fix : fixes) {
                        fix.applyFix(project, descriptor2);
                    }
                }

                @NotNull
                public String getName() {
                    return GroovyInspectionBundle.message("fix.class", psiClass.getName());
                }

                @Nls
                @NotNull
                public String getFamilyName() {
                    return "Fix range class";
                }
            };
        }
        return null;
    }

    private static int countImplementations(PsiClass clazz, GroovyResolveResult[] methods) {
        if (clazz.isInterface()) {
            return methods.length;
        }
        int result = 0;
        for (GroovyResolveResult method : methods) {
            PsiElement el = method.getElement();
            if (el instanceof PsiMethod && !((PsiMethod)el).hasModifierProperty("abstract")) {
                ++result;
                continue;
            }
            if (!(el instanceof PsiField)) continue;
            ++result;
        }
        return result;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        switch (args.length) {
            case 1: {
                return GroovyInspectionBundle.message("type.doesnt.implemnt.comparable", args);
            }
            case 2: {
                return GroovyInspectionBundle.message("type.doesnt.contain.method", args);
            }
        }
        throw new IncorrectOperationException("incorrect args:" + Arrays.toString(args));
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitRangeExpression(@NotNull GrRangeExpression range) {
            super.visitRangeExpression(range);
            PsiType type = range.getType();
            if (!(type instanceof GrRangeType)) {
                return;
            }
            PsiType iterationType = ((GrRangeType)type).getIterationType();
            if (iterationType == null) {
                return;
            }
            GroovyResolveResult[] nexts = ResolveUtil.getMethodCandidates(iterationType, "next", (PsiElement)range, PsiType.EMPTY_ARRAY);
            GroovyResolveResult[] previouses = ResolveUtil.getMethodCandidates(iterationType, "previous", (PsiElement)range, PsiType.EMPTY_ARRAY);
            if (nexts.length == 0) {
                this.registerError((PsiElement)range, iterationType.getPresentableText(), "next()");
            }
            if (previouses.length == 0) {
                this.registerError((PsiElement)range, iterationType.getPresentableText(), "previous()");
            }
            if (!InheritanceUtil.isInheritor((PsiType)iterationType, (String)"java.lang.Comparable")) {
                this.registerError((PsiElement)range, iterationType.getPresentableText());
            }
        }
    }
}

