/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntheticElement;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.resolve.ExpectedPackageNameProviderKt;

public class GrPackageInspection
extends BaseInspection {
    public boolean myCheckScripts = true;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Potentially confusing code constructs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Package name mismatch";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Package name mismatch";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("gr.package.inspection.check.scripts", new Object[0]), "myCheckScripts");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitFile(@NotNull GroovyFileBase file) {
                String actual;
                if (!(file instanceof GroovyFile)) {
                    return;
                }
                if (!GrPackageInspection.this.myCheckScripts && file.isScript()) {
                    return;
                }
                String expectedPackage = ExpectedPackageNameProviderKt.inferExpectedPackageName((GroovyFile)file);
                if (!expectedPackage.equals(actual = file.getPackageName())) {
                    PsiElement toHighlight = GrPackageInspection.getElementToHighlight((GroovyFile)file);
                    if (toHighlight == null) {
                        return;
                    }
                    this.registerError(toHighlight, "Package name mismatch. Actual: '" + actual + "', expected: '" + expectedPackage + "'", new LocalQuickFix[]{new ChangePackageQuickFix(expectedPackage), GroovyQuickFixFactory.getInstance().createGrMoveToDirFix(actual)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
    }

    @Nullable
    private static PsiElement getElementToHighlight(GroovyFile file) {
        PsiClass[] classes;
        GrPackageDefinition packageDefinition = file.getPackageDefinition();
        if (packageDefinition != null) {
            return packageDefinition;
        }
        for (PsiClass aClass : classes = file.getClasses()) {
            if (aClass instanceof SyntheticElement || !(aClass instanceof GrTypeDefinition)) continue;
            return ((GrTypeDefinition)aClass).getNameIdentifierGroovy();
        }
        GrTopStatement[] statements = file.getTopStatements();
        if (statements.length > 0) {
            GrTopStatement first = statements[0];
            if (first instanceof GrNamedElement) {
                return ((GrNamedElement)((Object)first)).getNameIdentifierGroovy();
            }
            return first;
        }
        return null;
    }

    public static class ChangePackageQuickFix
    implements LocalQuickFix {
        private final String myNewPackageName;

        public ChangePackageQuickFix(String newPackageName) {
            this.myNewPackageName = newPackageName;
        }

        @NotNull
        public String getFamilyName() {
            return GroovyBundle.message("fix.package.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiFile file = descriptor2.getPsiElement().getContainingFile();
            ((GroovyFile)file).setPackageName(this.myNewPackageName);
        }
    }
}

