/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReassignedLocalVarsChecker;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrReassignedInClosureLocalVarInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Potentially confusing code constructs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Local variable is reassigned in closure or anonymous class";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                GrControlFlowOwner refFlorOwner;
                super.visitReferenceExpression(referenceExpression);
                if (!PsiUtil.isLValue(referenceExpression)) {
                    return;
                }
                PsiElement resolved = referenceExpression.resolve();
                if (!PsiUtil.isLocalVariable(resolved)) {
                    return;
                }
                PsiType checked = GrReassignedLocalVarsChecker.getReassignedVarType(referenceExpression, false);
                if (checked == null) {
                    return;
                }
                GrControlFlowOwner varFlowOwner = ControlFlowUtils.findControlFlowOwner(resolved);
                if (GrReassignedInClosureLocalVarInspection.isOtherScopeAndType(referenceExpression, checked, varFlowOwner, refFlorOwner = ControlFlowUtils.findControlFlowOwner(referenceExpression))) {
                    String flowDescription = GrReassignedInClosureLocalVarInspection.getFlowDescription(refFlorOwner);
                    String message = GroovyInspectionBundle.message("local.var.0.is.reassigned", ((GrNamedElement)resolved).getName(), flowDescription);
                    this.registerError((PsiElement)referenceExpression, message, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
    }

    private static boolean isOtherScopeAndType(GrReferenceExpression referenceExpression, PsiType checked, GrControlFlowOwner varFlowOwner, GrControlFlowOwner refFlorOwner) {
        return varFlowOwner != refFlorOwner && !TypesUtil.isAssignable(referenceExpression.getType(), checked, referenceExpression);
    }

    private static String getFlowDescription(GrControlFlowOwner refFlorOwner) {
        String flowDescription = refFlorOwner instanceof GrClosableBlock ? GroovyInspectionBundle.message("closure", new Object[0]) : (refFlorOwner instanceof GrAnonymousClassDefinition ? GroovyInspectionBundle.message("anonymous.class", new Object[0]) : GroovyInspectionBundle.message("other.scope", new Object[0]));
        return flowDescription;
    }
}

