/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyEmptyStatementBodyInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        return "Statement with empty body";
    }

    @NotNull
    public String getGroupDisplayName() {
        return "Potentially confusing code constructs";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        if (args[0] instanceof GrIfStatement) {
            return "'#ref' statement has empty branch";
        }
        return "'#ref' statement has empty body";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitWhileStatement(@NotNull GrWhileStatement statement) {
            super.visitWhileStatement(statement);
            GrStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!Visitor.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitForStatement(@NotNull GrForStatement statement) {
            super.visitForStatement(statement);
            GrStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!Visitor.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            super.visitIfStatement(statement);
            GrStatement thenBranch = statement.getThenBranch();
            if (thenBranch != null && Visitor.isEmpty(thenBranch)) {
                this.registerStatementError(statement, statement);
                return;
            }
            GrStatement elseBranch = statement.getElseBranch();
            if (elseBranch != null && Visitor.isEmpty(elseBranch)) {
                this.registerStatementError(statement, statement);
            }
        }

        private static boolean isEmpty(GroovyPsiElement body) {
            if (!(body instanceof GrBlockStatement)) {
                return false;
            }
            GrBlockStatement block = (GrBlockStatement)body;
            GrOpenBlock openBlock = block.getBlock();
            PsiElement brace = openBlock.getLBrace();
            if (brace == null) {
                return false;
            }
            PsiElement nextNonWhitespace = PsiUtil.skipWhitespaces(brace.getNextSibling(), true);
            return nextNonWhitespace == openBlock.getRBrace();
        }
    }
}

