/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.codeInspection.utils.SideEffectChecker;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyConditionalCanBeConditionalCallInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        return "Conditional expression can be conditional call";
    }

    @NotNull
    public String getGroupDisplayName() {
        return "Control Flow";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Conditional expression can be call #loc";
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        return new CollapseConditionalFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            GrExpression condition = expression.getCondition();
            GrExpression thenBranch = expression.getThenBranch();
            GrExpression elseBranch = expression.getElseBranch();
            if (thenBranch == null || elseBranch == null) {
                return;
            }
            if (SideEffectChecker.mayHaveSideEffects(condition)) {
                return;
            }
            if (!((condition = (GrExpression)PsiUtil.skipParentheses(condition, false)) instanceof GrBinaryExpression)) {
                return;
            }
            GrBinaryExpression binaryCondition = (GrBinaryExpression)condition;
            GrExpression lhs = binaryCondition.getLeftOperand();
            GrExpression rhs = binaryCondition.getRightOperand();
            if (GrInspectionUtil.isInequality(binaryCondition) && GrInspectionUtil.isNull(elseBranch) && (GrInspectionUtil.isNull(lhs) && Visitor.isCallTargeting(thenBranch, rhs) || GrInspectionUtil.isNull(rhs) && Visitor.isCallTargeting(thenBranch, lhs))) {
                this.registerError(expression);
            }
            if (GrInspectionUtil.isEquality(binaryCondition) && GrInspectionUtil.isNull(thenBranch) && (GrInspectionUtil.isNull(lhs) && Visitor.isCallTargeting(elseBranch, rhs) || GrInspectionUtil.isNull(rhs) && Visitor.isCallTargeting(elseBranch, lhs))) {
                this.registerError(expression);
            }
        }

        private static boolean isCallTargeting(GrExpression call, GrExpression expression) {
            if (!(call instanceof GrMethodCallExpression)) {
                return false;
            }
            GrMethodCallExpression callExpression = (GrMethodCallExpression)call;
            GrExpression methodExpression = callExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return false;
            }
            GrReferenceExpression referenceExpression = (GrReferenceExpression)methodExpression;
            if (!GroovyTokenTypes.mDOT.equals(referenceExpression.getDotTokenType())) {
                return false;
            }
            return EquivalenceChecker.expressionsAreEquivalent(expression, referenceExpression.getQualifierExpression());
        }
    }

    private static class CollapseConditionalFix
    extends GroovyFix {
        private CollapseConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Replace with conditional call";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            GrConditionalExpression expression = (GrConditionalExpression)descriptor2.getPsiElement();
            GrBinaryExpression binaryCondition = (GrBinaryExpression)PsiUtil.skipParentheses(expression.getCondition(), false);
            GrMethodCallExpression call = GrInspectionUtil.isInequality(binaryCondition) ? (GrMethodCallExpression)expression.getThenBranch() : (GrMethodCallExpression)expression.getElseBranch();
            GrReferenceExpression methodExpression = (GrReferenceExpression)call.getInvokedExpression();
            GrExpression qualifier = methodExpression.getQualifierExpression();
            String methodName = methodExpression.getReferenceName();
            GrArgumentList argumentList = call.getArgumentList();
            CollapseConditionalFix.replaceExpression(expression, qualifier.getText() + "?." + methodName + argumentList.getText());
        }
    }
}

