/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;

public class GroovySwitchStatementWithNoDefaultInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Control Flow";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Switch statement with no default case";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "#ref statement with no default branch#loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
            GrCaseSection[] caseSections;
            super.visitSwitchStatement(switchStatement);
            for (GrCaseSection caseSection : caseSections = switchStatement.getCaseSections()) {
                if (!caseSection.isDefault()) continue;
                return;
            }
            this.registerError(switchStatement.getFirstChild());
        }
    }
}

