/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RemoveElementQuickFix
implements LocalQuickFix {
    private final String myName;
    private final Function<PsiElement, PsiElement> myElementFunction;

    public RemoveElementQuickFix(@NotNull String name, @NotNull Function<PsiElement, PsiElement> function) {
        this.myName = name;
        this.myElementFunction = function;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.myName;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement descriptorElement = descriptor2.getPsiElement();
        if (descriptorElement == null) {
            return;
        }
        PsiElement elementToRemove = (PsiElement)this.myElementFunction.fun((Object)descriptorElement);
        if (elementToRemove == null) {
            return;
        }
        elementToRemove.delete();
    }
}

