/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.metrics.StatementCountVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyOverlyLongMethodInspectionBase
extends GroovyMethodMetricInspection {
    @NotNull
    public String getDisplayName() {
        return "Overly long method";
    }

    @NotNull
    public String getGroupDisplayName() {
        return "Method Metrics";
    }

    @Override
    protected int getDefaultLimit() {
        return 30;
    }

    @Override
    protected String getConfigurationLabel() {
        return "Maximum statements per method:";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' is too long ( statement count =" + args[0] + '>' + args[1] + ')';
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod method) {
            super.visitMethod(method);
            int limit = GroovyOverlyLongMethodInspectionBase.this.getLimit();
            StatementCountVisitor visitor2 = new StatementCountVisitor();
            GrOpenBlock block = method.getBlock();
            if (block == null) {
                return;
            }
            block.accept(visitor2);
            int statementCount = visitor2.getStatementCount();
            if (statementCount <= limit) {
                return;
            }
            this.registerMethodError(method, statementCount, limit);
        }
    }
}

