/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;

public class GroovyEnumerationNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @NotNull
    public String getDisplayName() {
        return "Enumeration naming convention";
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            return "Enumeration name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            return "Enumeration name '#ref' is too long";
        }
        return "Enumeration name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 8;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitEnumDefinition(@NotNull GrEnumTypeDefinition aClass) {
            super.visitEnumDefinition(aClass);
            String name = aClass.getName();
            if (name == null) {
                return;
            }
            if (GroovyEnumerationNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerClassError(aClass, name);
        }
    }
}

