/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrRemoveModifierFix;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;

public class GrUnnecessaryPublicModifierInspection
extends GroovySuppressableInspectionTool
implements CleanupLocalInspectionTool {
    private static final LocalQuickFix FIX = new GrRemoveModifierFix("public");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new PsiElementVisitor(){

            public void visitElement(PsiElement modifier) {
                if (modifier.getNode().getElementType() != GroovyTokenTypes.kPUBLIC) {
                    return;
                }
                PsiElement list = modifier.getParent();
                if (!(list instanceof GrModifierList)) {
                    return;
                }
                PsiElement parent = list.getParent();
                if (parent instanceof GrVariableDeclaration) {
                    return;
                }
                holder.registerProblem(modifier, GroovyInspectionBundle.message("unnecessary.modifier.description", "public"), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{FIX});
            }
        };
    }
}

