/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.AfterCallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.IfEndInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ThrowingInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ControlFlowUtils {
    private static final Logger LOG = Logger.getInstance(ControlFlowUtils.class);

    public static boolean statementMayCompleteNormally(@Nullable GrStatement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof GrBreakStatement || statement instanceof GrContinueStatement || statement instanceof GrReturnStatement || statement instanceof GrThrowStatement) {
            return false;
        }
        if (statement instanceof GrForStatement) {
            return ControlFlowUtils.forStatementMayReturnNormally((GrForStatement)statement);
        }
        if (statement instanceof GrWhileStatement) {
            return ControlFlowUtils.whileStatementMayReturnNormally((GrWhileStatement)statement);
        }
        if (statement instanceof GrBlockStatement) {
            return ControlFlowUtils.blockMayCompleteNormally((GrBlockStatement)statement);
        }
        if (statement instanceof GrSynchronizedStatement) {
            GrSynchronizedStatement syncStatement = (GrSynchronizedStatement)statement;
            return ControlFlowUtils.openBlockMayCompleteNormally(syncStatement.getBody());
        }
        if (statement instanceof GrLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((GrLabeledStatement)statement);
        }
        if (statement instanceof GrIfStatement) {
            return ControlFlowUtils.ifStatementMayReturnNormally((GrIfStatement)statement);
        }
        if (statement instanceof GrTryCatchStatement) {
            return ControlFlowUtils.tryStatementMayReturnNormally((GrTryCatchStatement)statement);
        }
        if (statement instanceof GrSwitchStatement) {
            return ControlFlowUtils.switchStatementMayReturnNormally((GrSwitchStatement)statement);
        }
        return true;
    }

    private static boolean whileStatementMayReturnNormally(@NotNull GrWhileStatement loopStatement) {
        GrExpression test = loopStatement.getCondition();
        return !BoolUtils.isTrue(test) || ControlFlowUtils.statementIsBreakTarget(loopStatement);
    }

    private static boolean forStatementMayReturnNormally(@NotNull GrForStatement loopStatement) {
        return true;
    }

    private static boolean switchStatementMayReturnNormally(@NotNull GrSwitchStatement switchStatement) {
        if (ControlFlowUtils.statementIsBreakTarget(switchStatement)) {
            return true;
        }
        Object[] caseClauses = switchStatement.getCaseSections();
        if (ContainerUtil.find((Object[])caseClauses, section -> section.isDefault()) == null) {
            return true;
        }
        Object lastClause = caseClauses[caseClauses.length - 1];
        GrStatement[] statements = lastClause.getStatements();
        if (statements.length == 0) {
            return true;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1]);
    }

    private static boolean tryStatementMayReturnNormally(@NotNull GrTryCatchStatement tryStatement) {
        GrFinallyClause finallyBlock = tryStatement.getFinallyClause();
        if (finallyBlock != null && !ControlFlowUtils.openBlockMayCompleteNormally(finallyBlock.getBody())) {
            return false;
        }
        GrOpenBlock tryBlock = tryStatement.getTryBlock();
        if (ControlFlowUtils.openBlockMayCompleteNormally(tryBlock)) {
            return true;
        }
        for (GrCatchClause catchClause : tryStatement.getCatchClauses()) {
            if (!ControlFlowUtils.openBlockMayCompleteNormally(catchClause.getBody())) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayReturnNormally(@NotNull GrIfStatement ifStatement) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
            return true;
        }
        GrStatement elseBranch = ifStatement.getElseBranch();
        return elseBranch == null || ControlFlowUtils.statementMayCompleteNormally(elseBranch);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull GrLabeledStatement labeledStatement) {
        GrStatement statement = labeledStatement.getStatement();
        return ControlFlowUtils.statementMayCompleteNormally(statement) || ControlFlowUtils.statementIsBreakTarget(statement);
    }

    public static boolean blockMayCompleteNormally(@Nullable GrBlockStatement block) {
        GrStatement[] statements;
        if (block == null) {
            return true;
        }
        for (GrStatement statement : statements = block.getBlock().getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    public static boolean openBlockMayCompleteNormally(@Nullable GrOpenBlock block) {
        GrStatement[] statements;
        if (block == null) {
            return true;
        }
        for (GrStatement statement : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull GrStatement statement) {
        BreakFinder breakFinder = new BreakFinder(statement);
        statement.accept(breakFinder);
        return breakFinder.breakFound();
    }

    public static boolean statementContainsReturn(@NotNull GrStatement statement) {
        ReturnFinder returnFinder = new ReturnFinder();
        statement.accept(returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull GrStatement statement) {
        ContinueFinder continueFinder = new ContinueFinder(statement);
        statement.accept(continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean isInLoop(@NotNull GroovyPsiElement element) {
        return ControlFlowUtils.isInForStatementBody(element) || ControlFlowUtils.isInWhileStatementBody(element);
    }

    public static boolean isInFinallyBlock(@NotNull GroovyPsiElement element) {
        GrFinallyClause containingClause = (GrFinallyClause)PsiTreeUtil.getParentOfType((PsiElement)element, GrFinallyClause.class);
        if (containingClause == null) {
            return false;
        }
        GrOpenBlock body = containingClause.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInWhileStatementBody(@NotNull GroovyPsiElement element) {
        GrWhileStatement whileStatement = (GrWhileStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GrWhileStatement.class);
        if (whileStatement == null) {
            return false;
        }
        GrStatement body = whileStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInForStatementBody(@NotNull GroovyPsiElement element) {
        GrForStatement forStatement = (GrForStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GrForStatement.class);
        if (forStatement == null) {
            return false;
        }
        GrStatement body = forStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    public static GrStatement stripBraces(@NotNull GrStatement branch) {
        if (branch instanceof GrBlockStatement) {
            GrBlockStatement block = (GrBlockStatement)branch;
            GrStatement[] statements = block.getBlock().getStatements();
            if (statements.length == 1) {
                return statements[0];
            }
            return block;
        }
        return branch;
    }

    public static boolean statementCompletesWithStatement(@NotNull GrStatement containingStatement, @NotNull GrStatement statement) {
        GrStatement statementToCheck = statement;
        while (!statementToCheck.equals(containingStatement)) {
            GrStatement container = ControlFlowUtils.getContainingStatement(statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof GrBlockStatement && !ControlFlowUtils.statementIsLastInBlock((GrBlockStatement)container, statementToCheck)) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            statementToCheck = container;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull GrBlockStatement body, @NotNull GrStatement statement) {
        GrStatement statementToCheck = statement;
        while (statementToCheck != null) {
            PsiElement parent;
            PsiElement container = statementToCheck.getParent();
            if (container == null) {
                return false;
            }
            if (container instanceof GrLoopStatement) {
                return false;
            }
            if (container instanceof GrCaseSection) {
                GrCaseSection caseSection = (GrCaseSection)container;
                if (!ControlFlowUtils.statementIsLastInBlock(caseSection, statementToCheck)) {
                    return false;
                }
                parent = container.getParent();
                assert (parent instanceof GrSwitchStatement);
                GrSwitchStatement switchStatement = (GrSwitchStatement)parent;
                Object[] sections = switchStatement.getCaseSections();
                if (ArrayUtil.getLastElement((Object[])sections) != caseSection) {
                    return false;
                }
            } else if (container instanceof GrOpenBlock) {
                GrBlockStatement blockStatement;
                GrOpenBlock block = (GrOpenBlock)container;
                if (!ControlFlowUtils.statementIsLastInBlock(block, statementToCheck)) {
                    return false;
                }
                parent = block.getParent();
                if (parent instanceof GrBlockStatement && (blockStatement = (GrBlockStatement)parent) == body) {
                    return true;
                }
            } else if (container instanceof GrClosableBlock) {
                return false;
            }
            statementToCheck = ControlFlowUtils.getContainingStatement(statementToCheck);
        }
        return false;
    }

    public static boolean openBlockCompletesWithStatement(@NotNull GrCodeBlock body, @NotNull GrStatement statement) {
        GroovyPsiElement elementToCheck = statement;
        while (elementToCheck != null) {
            GrSwitchStatement switchStatement;
            GrCaseSection[] sections;
            GroovyPsiElement container = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)elementToCheck, (Class[])new Class[]{GrStatement.class, GrCodeBlock.class, GrCaseSection.class});
            if (container == null) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof GrCaseSection && container == (sections = (switchStatement = (GrSwitchStatement)container.getParent()).getCaseSections())[sections.length - 1]) {
                return false;
            }
            if (container instanceof GrCodeBlock) {
                GrCodeBlock codeBlock;
                if (elementToCheck instanceof GrStatement && !ControlFlowUtils.statementIsLastInBlock(codeBlock = (GrCodeBlock)container, elementToCheck)) {
                    return false;
                }
                if (container instanceof GrOpenBlock || container instanceof GrClosableBlock) {
                    if (container.equals(body)) {
                        return true;
                    }
                    elementToCheck = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)container, GrStatement.class);
                    continue;
                }
                elementToCheck = container;
                continue;
            }
            elementToCheck = container;
        }
        return false;
    }

    public static boolean closureCompletesWithStatement(@NotNull GrClosableBlock body, @NotNull GrStatement statement) {
        GroovyPsiElement statementToCheck = statement;
        while (statementToCheck instanceof GrExpression || statementToCheck instanceof GrReturnStatement) {
            GroovyPsiElement container = ControlFlowUtils.getContainingStatementOrBlock(statementToCheck);
            if (container == null) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof GrCodeBlock) {
                if (!ControlFlowUtils.statementIsLastInBlock((GrCodeBlock)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)container, GrStatement.class);
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    private static boolean isLoop(@NotNull PsiElement element) {
        return element instanceof GrLoopStatement;
    }

    @Nullable
    private static GrStatement getContainingStatement(@NotNull GroovyPsiElement statement) {
        return (GrStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, GrStatement.class);
    }

    @Nullable
    private static GroovyPsiElement getContainingStatementOrBlock(@NotNull GroovyPsiElement statement) {
        return (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{GrStatement.class, GrCodeBlock.class});
    }

    private static boolean statementIsLastInBlock(@NotNull GrBlockStatement block, @NotNull GrStatement statement) {
        return ControlFlowUtils.statementIsLastInBlock(block.getBlock(), statement);
    }

    private static boolean statementIsLastInBlock(@NotNull GrStatementOwner block, @NotNull GrStatement statement) {
        GrStatement[] statements = block.getStatements();
        for (int i = statements.length - 1; i >= 0; --i) {
            GrStatement childStatement = statements[i];
            if (statement.equals(childStatement)) {
                return true;
            }
            if (childStatement instanceof GrReturnStatement) continue;
            return false;
        }
        return false;
    }

    @NotNull
    public static List<GrStatement> collectReturns(@Nullable PsiElement element) {
        return ControlFlowUtils.collectReturns(element, element instanceof GrCodeBlock || element instanceof GroovyFile);
    }

    @NotNull
    public static List<GrStatement> collectReturns(@Nullable PsiElement element, boolean allExitPoints) {
        if (element == null) {
            return Collections.emptyList();
        }
        Instruction[] flow = element instanceof GrControlFlowOwner ? ((GrControlFlowOwner)element).getControlFlow() : new ControlFlowBuilder(element.getProject()).buildControlFlow((GroovyPsiElement)element);
        return ControlFlowUtils.collectReturns(flow, allExitPoints);
    }

    @NotNull
    public static List<GrStatement> collectReturns(@NotNull Instruction[] flow, final boolean allExitPoints) {
        boolean[] visited = new boolean[flow.length];
        final ArrayList<GrStatement> res = new ArrayList<GrStatement>();
        ControlFlowUtils.visitAllExitPointsInner(flow[flow.length - 1], flow[0], visited, new ExitPointVisitor(){

            @Override
            public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                PsiElement element = instruction.getElement();
                if (element instanceof GrReturnStatement || allExitPoints && instruction instanceof MaybeReturnInstruction) {
                    res.add((GrStatement)element);
                }
                return true;
            }
        });
        return res;
    }

    @Nullable
    public static GrExpression extractReturnExpression(GrStatement returnStatement) {
        if (returnStatement instanceof GrReturnStatement) {
            return ((GrReturnStatement)returnStatement).getReturnValue();
        }
        if (returnStatement instanceof GrExpression) {
            return (GrExpression)returnStatement;
        }
        return null;
    }

    public static boolean isIncOrDecOperand(GrReferenceExpression referenceExpression) {
        PsiElement parent = referenceExpression.getParent();
        if (parent instanceof GrUnaryExpression) {
            IElementType opType = ((GrUnaryExpression)parent).getOperationTokenType();
            return opType == GroovyTokenTypes.mDEC || opType == GroovyTokenTypes.mINC;
        }
        return false;
    }

    public static String dumpControlFlow(Instruction[] instructions) {
        StringBuilder builder = new StringBuilder();
        for (Instruction instruction : instructions) {
            builder.append(instruction.toString()).append("\n");
        }
        return builder.toString();
    }

    @Nullable
    public static ReadWriteVariableInstruction findRWInstruction(GrReferenceExpression refExpr, Instruction[] flow) {
        for (Instruction instruction : flow) {
            if (!(instruction instanceof ReadWriteVariableInstruction) || instruction.getElement() != refExpr) continue;
            return (ReadWriteVariableInstruction)instruction;
        }
        return null;
    }

    @Nullable
    public static Instruction findNearestInstruction(PsiElement place, Instruction[] flow) {
        ArrayList<Instruction> applicable = new ArrayList<Instruction>();
        for (Instruction instruction : flow) {
            PsiElement element = instruction.getElement();
            if (element == null) continue;
            if (element == place) {
                return instruction;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)place, (boolean)true)) continue;
            applicable.add(instruction);
        }
        if (applicable.isEmpty()) {
            return null;
        }
        Collections.sort(applicable, (o1, o2) -> {
            PsiElement e1 = o1.getElement();
            PsiElement e2 = o2.getElement();
            LOG.assertTrue(e1 != null);
            LOG.assertTrue(e2 != null);
            TextRange t1 = e1.getTextRange();
            TextRange t2 = e2.getTextRange();
            int s1 = t1.getStartOffset();
            int s2 = t2.getStartOffset();
            if (s1 == s2) {
                return t1.getEndOffset() - t2.getEndOffset();
            }
            return s2 - s1;
        });
        return (Instruction)applicable.get(0);
    }

    public static Set<GrExpression> getAllReturnValues(@NotNull GrControlFlowOwner block) {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)block, () -> {
            HashSet result = new HashSet();
            ControlFlowUtils.visitAllExitPoints(block, new ExitPointVisitor((Set)result){
                final /* synthetic */ Set val$result;
                {
                    this.val$result = set;
                }

                @Override
                public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                    ContainerUtil.addIfNotNull((Collection)this.val$result, (Object)returnValue);
                    return true;
                }
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{block});
        });
    }

    public static boolean isReturnValue(@NotNull GrExpression expression, @NotNull GrControlFlowOwner flowOwner) {
        return ControlFlowUtils.getAllReturnValues(flowOwner).contains(expression);
    }

    public static boolean visitAllExitPoints(@Nullable GrControlFlowOwner block, ExitPointVisitor visitor2) {
        if (block == null) {
            return true;
        }
        Instruction[] flow = block.getControlFlow();
        boolean[] visited = new boolean[flow.length];
        return ControlFlowUtils.visitAllExitPointsInner(flow[flow.length - 1], flow[0], visited, visitor2);
    }

    private static boolean visitAllExitPointsInner(Instruction last, Instruction first, boolean[] visited, ExitPointVisitor visitor2) {
        PsiElement element;
        if (first == last) {
            return true;
        }
        if (last instanceof AfterCallInstruction) {
            visited[last.num()] = true;
            return ControlFlowUtils.visitAllExitPointsInner(((AfterCallInstruction)last).myCall, first, visited, visitor2);
        }
        if (last instanceof MaybeReturnInstruction) {
            return visitor2.visitExitPoint(last, (GrExpression)last.getElement());
        }
        if (last instanceof IfEndInstruction) {
            visited[last.num()] = true;
            for (Instruction instruction : last.allPredecessors()) {
                if (ControlFlowUtils.visitAllExitPointsInner(instruction, first, visited, visitor2)) continue;
                return false;
            }
            return true;
        }
        if (last instanceof ThrowingInstruction && !((element = last.getElement()) instanceof GrThrowStatement) && !(element instanceof GrAssertStatement)) {
            return true;
        }
        element = last.getElement();
        if (element != null) {
            GrExpression returnValue = element instanceof GrReturnStatement ? ((GrReturnStatement)element).getReturnValue() : (element instanceof GrExpression && PsiUtil.isExpressionStatement(element) ? (GrExpression)element : null);
            return visitor2.visitExitPoint(last, returnValue);
        }
        visited[last.num()] = true;
        for (Instruction pred : last.allPredecessors()) {
            if (visited[pred.num()] || ControlFlowUtils.visitAllExitPointsInner(pred, first, visited, visitor2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static GrControlFlowOwner findControlFlowOwner(PsiElement place) {
        for (place = place.getContext(); place != null; place = place.getContext()) {
            if (place instanceof GrControlFlowOwner && ((GrControlFlowOwner)place).isTopControlFlowOwner()) {
                return (GrControlFlowOwner)place;
            }
            if (place instanceof GrMethod) {
                return ((GrMethod)place).getBlock();
            }
            if (!(place instanceof GrClassInitializer)) continue;
            return ((GrClassInitializer)place).getBlock();
        }
        return null;
    }

    public static List<ReadWriteVariableInstruction> findAccess(GrVariable local, PsiElement place, boolean ahead, boolean writeAccessOnly) {
        LOG.assertTrue(!(local instanceof GrField), local.getClass());
        GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(place);
        assert (owner != null);
        Instruction cur = ControlFlowUtils.findInstruction(place, owner.getControlFlow());
        if (cur == null) {
            throw new IllegalArgumentException("place is not in the flow");
        }
        return ControlFlowUtils.findAccess(local, ahead, writeAccessOnly, cur);
    }

    public static List<ReadWriteVariableInstruction> findAccess(GrVariable local, boolean ahead, boolean writeAccessOnly, Instruction cur) {
        Instruction instruction;
        String name = local.getName();
        ArrayList<ReadWriteVariableInstruction> result = new ArrayList<ReadWriteVariableInstruction>();
        HashSet visited = new HashSet();
        visited.add((Object)cur);
        ArrayDeque<Instruction> queue = new ArrayDeque<Instruction>();
        for (Instruction i : ahead ? cur.allSuccessors() : cur.allPredecessors()) {
            if (!visited.add((Object)i)) continue;
            queue.add(i);
        }
        while ((instruction = (Instruction)queue.poll()) != null) {
            ReadWriteVariableInstruction rw;
            if (instruction instanceof ReadWriteVariableInstruction && name.equals((rw = (ReadWriteVariableInstruction)instruction).getVariableName())) {
                if (rw.isWrite()) {
                    result.add(rw);
                    continue;
                }
                if (!writeAccessOnly) {
                    result.add(rw);
                }
            }
            for (Instruction i : ahead ? instruction.allSuccessors() : instruction.allPredecessors()) {
                if (!visited.add((Object)i)) continue;
                queue.add(i);
            }
        }
        return result;
    }

    @Nullable
    public static Instruction findInstruction(PsiElement place, Instruction[] controlFlow) {
        return (Instruction)ContainerUtil.find((Object[])controlFlow, instruction -> instruction.getElement() == place);
    }

    public static List<Instruction> findAllInstructions(PsiElement place, Instruction[] controlFlow) {
        return ContainerUtil.findAll((Object[])controlFlow, instruction -> instruction.getElement() == place);
    }

    @NotNull
    public static List<BitSet> inferWriteAccessMap(final Instruction[] flow, final GrVariable var) {
        Semilattice<BitSet> sem = new Semilattice<BitSet>(){

            @Override
            @NotNull
            public BitSet join(@NotNull List<BitSet> ins) {
                BitSet result = new BitSet(flow.length);
                for (BitSet set : ins) {
                    result.or(set);
                }
                return result;
            }

            @Override
            public boolean eq(@NotNull BitSet e1, @NotNull BitSet e2) {
                return e1.equals(e2);
            }
        };
        DfaInstance<BitSet> dfa = new DfaInstance<BitSet>(){

            @Override
            public void fun(@NotNull BitSet bitSet, @NotNull Instruction instruction) {
                GrReferenceExpression ref;
                if (!(instruction instanceof ReadWriteVariableInstruction)) {
                    return;
                }
                if (!((ReadWriteVariableInstruction)instruction).isWrite()) {
                    return;
                }
                PsiElement element = instruction.getElement();
                if (element instanceof GrVariable && element != var) {
                    return;
                }
                if (element instanceof GrReferenceExpression && ((ref = (GrReferenceExpression)element).isQualified() || ref.resolve() != var)) {
                    return;
                }
                if (!((ReadWriteVariableInstruction)instruction).getVariableName().equals(var.getName())) {
                    return;
                }
                bitSet.clear();
                bitSet.set(instruction.num());
            }

            @Override
            @NotNull
            public BitSet initial() {
                return new BitSet(flow.length);
            }
        };
        return new DFAEngine<BitSet>(flow, dfa, sem).performForceDFA();
    }

    public static interface ExitPointVisitor {
        public boolean visitExitPoint(Instruction var1, @Nullable GrExpression var2);
    }

    private static class ContinueFinder
    extends GroovyRecursiveElementVisitor {
        private boolean m_found = false;
        private final GrStatement m_target;

        private ContinueFinder(@NotNull GrStatement target) {
            this.m_target = target;
        }

        public boolean continueFound() {
            return this.m_found;
        }

        @Override
        public void visitContinueStatement(@NotNull GrContinueStatement continueStatement) {
            if (this.m_found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            GrStatement exitedStatement = continueStatement.findTargetStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }
    }

    private static class BreakFinder
    extends GroovyRecursiveElementVisitor {
        private boolean m_found = false;
        private final GrStatement m_target;

        private BreakFinder(@NotNull GrStatement target) {
            this.m_target = target;
        }

        public boolean breakFound() {
            return this.m_found;
        }

        @Override
        public void visitBreakStatement(@NotNull GrBreakStatement breakStatement) {
            if (this.m_found) {
                return;
            }
            super.visitBreakStatement(breakStatement);
            GrStatement exitedStatement = breakStatement.findTargetStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }
    }

    private static class ReturnFinder
    extends GroovyRecursiveElementVisitor {
        private boolean m_found = false;

        private ReturnFinder() {
        }

        public boolean returnFound() {
            return this.m_found;
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            if (this.m_found) {
                return;
            }
            super.visitReturnStatement(returnStatement);
            this.m_found = true;
        }
    }
}

