/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.validity;

import com.intellij.psi.PsiElement;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyDuplicateSwitchBranchInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Validity issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Duplicate switch case";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Duplicate switch case '#ref' #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static GrCaseLabel[] collectCaseLabels(final GrSwitchStatement containingStatelent) {
        final HashSet labels = new HashSet();
        GroovyRecursiveElementVisitor visitor2 = new GroovyRecursiveElementVisitor(){

            @Override
            public void visitCaseLabel(@NotNull GrCaseLabel grCaseLabel) {
                super.visitCaseLabel(grCaseLabel);
                labels.add(grCaseLabel);
            }

            @Override
            public void visitSwitchStatement(@NotNull GrSwitchStatement grSwitchStatement) {
                if (containingStatelent.equals(grSwitchStatement)) {
                    super.visitSwitchStatement(grSwitchStatement);
                }
            }
        };
        containingStatelent.accept(visitor2);
        return labels.toArray(new GrCaseLabel[labels.size()]);
    }

    @Nullable
    private static GrExpression getExpressionForCaseLabel(GrCaseLabel label) {
        for (PsiElement child : label.getChildren()) {
            if (!(child instanceof GrExpression)) continue;
            return (GrExpression)child;
        }
        return null;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull GrSwitchStatement grSwitchStatement) {
            super.visitSwitchStatement(grSwitchStatement);
            HashSet<GrExpression> duplicateExpressions = new HashSet<GrExpression>();
            GrCaseLabel[] labels = GroovyDuplicateSwitchBranchInspection.collectCaseLabels(grSwitchStatement);
            for (int i = 0; i < labels.length; ++i) {
                GrCaseLabel label1 = labels[i];
                GrExpression expression1 = GroovyDuplicateSwitchBranchInspection.getExpressionForCaseLabel(label1);
                for (int j = i + 1; j < labels.length; ++j) {
                    GrCaseLabel label2 = labels[j];
                    GrExpression expression2 = GroovyDuplicateSwitchBranchInspection.getExpressionForCaseLabel(label2);
                    if (!EquivalenceChecker.expressionsAreEquivalent(expression1, expression2)) continue;
                    duplicateExpressions.add(expression1);
                    duplicateExpressions.add(expression2);
                }
            }
            for (GrExpression duplicateExpression : duplicateExpressions) {
                this.registerError(duplicateExpression);
            }
        }
    }
}

