/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.validity;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class GroovyUnreachableStatementInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Validity issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Unreachable Statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Unreachable statement #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitClosure(@NotNull GrClosableBlock closure) {
            super.visitClosure(closure);
            GrStatement[] statements = closure.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                this.checkPair(statements[i], statements[i + 1]);
            }
        }

        @Override
        public void visitOpenBlock(@NotNull GrOpenBlock block) {
            super.visitOpenBlock(block);
            GrStatement[] statements = block.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                this.checkPair(statements[i], statements[i + 1]);
            }
        }

        private void checkPair(GrStatement prev, GrStatement statement) {
            if (!ControlFlowUtils.statementMayCompleteNormally(prev)) {
                this.registerError(statement);
            }
        }
    }
}

