/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.compiler.ExcludeFromStubGenerationAction;

public class GroovyStubNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    static final String GROOVY_STUBS = "groovyStubs";
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"GroovyStubNotificationProvider");
    private final Project myProject;

    public GroovyStubNotificationProvider(Project project) {
        this.myProject = project;
    }

    @Nullable
    @VisibleForTesting
    public static PsiClass findClassByStub(Project project, VirtualFile stubFile) {
        String[] components = StringUtil.trimEnd((String)stubFile.getPath(), (String)".java").split("[\\\\/]");
        int stubs = Arrays.asList(components).indexOf(GROOVY_STUBS);
        if (stubs < 0 || stubs >= components.length - 3) {
            return null;
        }
        String moduleName = components[stubs + 1];
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        if (module == null) {
            return null;
        }
        String fqn = StringUtil.join(Arrays.asList(components).subList(stubs + 3, components.length), (String)".");
        return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.moduleScope((Module)module));
    }

    private static EditorNotificationPanel decorateStubFile(VirtualFile file, Project project) {
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText("This stub is generated for Groovy class to make Groovy-Java cross-compilation possible");
        panel.createActionLabel("Go to the Groovy class", () -> DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            PsiClass original = GroovyStubNotificationProvider.findClassByStub(project, file);
            if (original != null) {
                original.navigate(true);
            }
        }));
        panel.createActionLabel("Exclude from stub generation", () -> DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            PsiClass psiClass = GroovyStubNotificationProvider.findClassByStub(project, file);
            if (psiClass != null) {
                ExcludeFromStubGenerationAction.doExcludeFromStubGeneration(psiClass.getContainingFile());
            }
        }));
        return panel;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        PsiClass psiClass;
        if (file.getName().endsWith(".java") && file.getPath().contains(GROOVY_STUBS) && (psiClass = GroovyStubNotificationProvider.findClassByStub(this.myProject, file)) != null) {
            return GroovyStubNotificationProvider.decorateStubFile(file, this.myProject);
        }
        return null;
    }
}

