/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.incremental.groovy.CheckResourcesTarget;
import org.jetbrains.jps.incremental.groovy.GroovyResourceChecker;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class GroovyTargetScopeProvider
extends BuildTargetScopeProvider {
    @NotNull
    public List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildTargetScopes(@NotNull CompileScope baseScope, @NotNull CompilerFilter filter, @NotNull Project project, boolean forceBuild) {
        Boolean checkResourcesRebuild = (Boolean)baseScope.getUserData(GroovyResourceChecker.CHECKING_RESOURCES_REBUILD);
        if (checkResourcesRebuild == null) {
            return Collections.emptyList();
        }
        return JBIterable.of((Object[])new CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope[]{GroovyTargetScopeProvider.createTargets(project, forceBuild |= checkResourcesRebuild.booleanValue(), JavaResourceRootType.RESOURCE, CheckResourcesTarget.PRODUCTION), GroovyTargetScopeProvider.createTargets(project, forceBuild, JavaResourceRootType.TEST_RESOURCE, CheckResourcesTarget.TESTS)}).filter(Condition.NOT_NULL).toList();
    }

    @Nullable
    private static CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope createTargets(@NotNull Project project, boolean forceBuild, JavaResourceRootType rootType, CheckResourcesTarget.Type targetType) {
        List<Module> withResources = GroovyTargetScopeProvider.getModulesWithGroovyResources(project, rootType);
        return withResources.isEmpty() ? null : CmdlineProtoUtil.createTargetsScope((String)targetType.getTypeId(), (List)ContainerUtil.map(withResources, Module::getName), (boolean)forceBuild);
    }

    private static List<Module> getModulesWithGroovyResources(@NotNull Project project, @NotNull JpsModuleSourceRootType<?> rootType) {
        return ContainerUtil.filter((Object[])ModuleManager.getInstance((Project)project).getModules(), module -> GroovyTargetScopeProvider.containsGroovyResources(rootType, module));
    }

    static boolean containsGroovyResources(@NotNull JpsModuleSourceRootType<?> rootType, Module module) {
        return ContainerUtil.exists((Iterable)ModuleRootManager.getInstance((Module)module).getSourceRoots(rootType), root -> GroovyTargetScopeProvider.containsGroovyResources(module, root));
    }

    private static boolean containsGroovyResources(Module module, VirtualFile root) {
        return !ModuleRootManager.getInstance((Module)module).getFileIndex().iterateContentUnderDirectory(root, file -> file.isDirectory() || GroovyFileType.GROOVY_FILE_TYPE != file.getFileType());
    }
}

