/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.GroovyFrameworkConfigNotification;

public class ConfigureGroovyLibraryNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"configure.groovy.library");
    private final Project myProject;
    private final Set<FileType> supportedFileTypes;

    public ConfigureGroovyLibraryNotificationProvider(Project project, final EditorNotifications notifications) {
        this.myProject = project;
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                notifications.updateAllNotifications();
            }
        });
        this.supportedFileTypes = new HashSet<FileType>();
        this.supportedFileTypes.add((FileType)GroovyFileType.GROOVY_FILE_TYPE);
        for (GroovyFrameworkConfigNotification configNotification : (GroovyFrameworkConfigNotification[])GroovyFrameworkConfigNotification.EP_NAME.getExtensions()) {
            Collections.addAll(this.supportedFileTypes, configNotification.getFrameworkFileTypes());
        }
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        try {
            if (!this.supportedFileTypes.contains(file.getFileType())) {
                return null;
            }
            if (StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle")) {
                return null;
            }
            if (CompilerManager.getInstance((Project)this.myProject).isExcludedFromCompilation(file)) {
                return null;
            }
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
            if (module == null) {
                return null;
            }
            if (ConfigureGroovyLibraryNotificationProvider.isMavenModule(module)) {
                return null;
            }
            for (GroovyFrameworkConfigNotification configNotification : (GroovyFrameworkConfigNotification[])GroovyFrameworkConfigNotification.EP_NAME.getExtensions()) {
                if (!configNotification.hasFrameworkStructure(module)) continue;
                if (!configNotification.hasFrameworkLibrary(module)) {
                    return (EditorNotificationPanel)configNotification.createConfigureNotificationPanel(module);
                }
                return null;
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean isMavenModule(@NotNull Module module) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (root.findChild("pom.xml") == null) continue;
            return true;
        }
        return false;
    }
}

