/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroovyRefRenderer
extends NodeRendererImpl {
    public GroovyRefRenderer() {
        super("Groovy Reference");
        this.myProperties.setEnabled(true);
    }

    public String getUniqueId() {
        return "GroovyRefRenderer";
    }

    public boolean isApplicable(Type type) {
        return type instanceof ReferenceType && DebuggerUtils.instanceOf((Type)type, (String)"groovy.lang.Reference");
    }

    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        ValueDescriptor fieldDescriptor = GroovyRefRenderer.getWrappedDescriptor(value, evaluationContext.getProject());
        GroovyRefRenderer.getDelegateRenderer(evaluationContext.getDebugProcess(), fieldDescriptor).buildChildren(fieldDescriptor.getValue(), builder, evaluationContext);
    }

    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        ValueDescriptor fieldDescriptor = GroovyRefRenderer.getWrappedDescriptor(((ValueDescriptor)node.getParent().getDescriptor()).getValue(), context.getProject());
        return GroovyRefRenderer.getDelegateRenderer(context.getDebugProcess(), fieldDescriptor).getChildValueExpression(node, context);
    }

    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        ValueDescriptor fieldDescriptor = GroovyRefRenderer.getWrappedDescriptor(value, evaluationContext.getProject());
        return GroovyRefRenderer.getDelegateRenderer(evaluationContext.getDebugProcess(), fieldDescriptor).isExpandable(fieldDescriptor.getValue(), evaluationContext, (NodeDescriptor)fieldDescriptor);
    }

    public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        ValueDescriptor fieldDescriptor = GroovyRefRenderer.getWrappedDescriptor(descriptor2.getValue(), evaluationContext.getProject(), descriptor2);
        return GroovyRefRenderer.getDelegateRenderer(evaluationContext.getDebugProcess(), fieldDescriptor).calcLabel(fieldDescriptor, evaluationContext, listener);
    }

    private static NodeRenderer getDelegateRenderer(DebugProcess debugProcess, ValueDescriptor fieldDescriptor) {
        return ((DebugProcessImpl)debugProcess).getAutoRenderer(fieldDescriptor);
    }

    private static ValueDescriptor getWrappedDescriptor(Value ref, Project project) {
        return GroovyRefRenderer.getWrappedDescriptor(ref, project, null);
    }

    private static ValueDescriptor getWrappedDescriptor(Value ref, Project project, final @Nullable ValueDescriptor originalDescriptor) {
        final Field field = ((ObjectReference)ref).referenceType().fieldByName("value");
        final Value wrapped = ((ObjectReference)ref).getValue(field);
        return new ValueDescriptorImpl(project, wrapped){

            public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
                return wrapped;
            }

            public void setValueLabel(@NotNull String label) {
                if (originalDescriptor != null) {
                    originalDescriptor.setValueLabel(label);
                }
            }

            public String calcValueName() {
                return field.name();
            }

            public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
                return JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText("this." + field.name(), null);
            }
        };
    }

    @Nullable
    public String getIdLabel(Value value, DebugProcess process) {
        ValueDescriptor fieldDescriptor = GroovyRefRenderer.getWrappedDescriptor(value, process.getProject());
        return ((NodeRendererImpl)GroovyRefRenderer.getDelegateRenderer(process, fieldDescriptor)).getIdLabel(fieldDescriptor.getValue(), process);
    }
}

