/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dgm.DGMUtil;

public class DGMReferenceContributor
extends PsiReferenceContributor {
    private final JavaClassReferenceProvider myProvider = new JavaClassReferenceProvider();

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement((IElementType)PropertiesTokenTypes.VALUE_CHARACTERS), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (!DGMUtil.isInDGMFile(element)) {
                    return PsiReference.EMPTY_ARRAY;
                }
                IProperty parent = (IProperty)element.getParent();
                if (!"extensionClasses".equals(parent.getName())) {
                    return PsiReference.EMPTY_ARRAY;
                }
                ArrayList result = new ArrayList();
                String text = element.getText();
                int i = 0;
                while ((i = DGMReferenceContributor.skipWhiteSpace(i, text)) < text.length()) {
                    int end = DGMReferenceContributor.findWhiteSpaceOrComma(i, text);
                    if (end <= text.length()) {
                        JavaClassReferenceSet set = new JavaClassReferenceSet(text.substring(i, end), element, i, true, DGMReferenceContributor.this.myProvider);
                        ContainerUtil.addAll(result, (Object[])set.getAllReferences());
                    }
                    i = end;
                    if ((i = DGMReferenceContributor.skipWhiteSpace(i, text)) == text.length()) break;
                    if (text.charAt(i) == ',') {
                        ++i;
                    }
                    i = DGMReferenceContributor.skipWhiteSpace(i, text);
                }
                return result.toArray(new PsiReference[result.size()]);
            }
        });
    }

    private static int skipWhiteSpace(int i, String text) {
        while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static int findWhiteSpaceOrComma(int i, String text) {
        while (i < text.length() && !Character.isWhitespace(text.charAt(i)) && text.charAt(i) != ',') {
            ++i;
        }
        return i;
    }
}

