/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;

public class CompositeContextFilter
implements ContextFilter {
    private final List<? extends ContextFilter> myFilters;
    private final boolean myAnd;

    private CompositeContextFilter(List<? extends ContextFilter> filters, boolean and) {
        this.myFilters = filters;
        this.myAnd = and;
    }

    @Override
    public boolean isApplicable(GroovyClassDescriptor descriptor2, ProcessingContext ctx) {
        for (ContextFilter contextFilter : this.myFilters) {
            if (this.myAnd == contextFilter.isApplicable(descriptor2, ctx)) continue;
            return !this.myAnd;
        }
        return this.myAnd;
    }

    @NotNull
    public static ContextFilter compose(@NotNull List<? extends ContextFilter> filters, boolean and) {
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return new CompositeContextFilter(filters, and);
    }
}

