/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.testIntegration.GroovyTestFramework;

public class SpockTestFramework
extends GroovyTestFramework {
    @Override
    @NotNull
    public String getName() {
        return "Spock";
    }

    @Override
    public String getLibraryPath() {
        return null;
    }

    @Override
    @Nullable
    public String getDefaultSuperClass() {
        return "spock.lang.Specification";
    }

    @Override
    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Spock_SetUp_Method.groovy");
    }

    @Override
    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Spock cleanup Method.groovy");
    }

    @Override
    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Spock Test Method.groovy");
    }

    @Override
    public boolean isTestMethod(PsiElement element) {
        return SpockUtils.isTestMethod(element);
    }

    @Override
    protected String getMarkerClassFQName() {
        return "spock.lang.Specification";
    }

    @Override
    protected boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        return clazz.getLanguage() == GroovyLanguage.INSTANCE && InheritanceUtil.isInheritor((PsiClass)clazz, (String)"spock.lang.Specification");
    }

    private PsiMethod findSpecificMethod(@NotNull PsiClass clazz, String methodName) {
        if (!this.isTestClass(clazz, false)) {
            return null;
        }
        for (PsiMethod method : clazz.findMethodsByName(methodName, false)) {
            if (method.getParameterList().getParametersCount() != 0) continue;
            return method;
        }
        return null;
    }

    @Override
    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        return this.findSpecificMethod(clazz, "setup");
    }

    @Override
    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        return this.findSpecificMethod(clazz, "cleanup");
    }

    @Override
    public char getMnemonic() {
        return 'S';
    }
}

